package io.inverno.mod.security.jose;

import io.inverno.core.annotation.Overridable;
import io.inverno.core.annotation.Wrapper;
import io.inverno.mod.configuration.ConfigurationKey.Parameter;
import io.inverno.mod.configuration.ConfigurationLoaderSupport;
import io.inverno.mod.configuration.ConfigurationSource;
import java.lang.Boolean;
import java.lang.String;
import java.net.URI;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.processing.Generated;

@Generated(value="io.inverno.mod.configuration.compiler.internal.ConfigurationCompilerPlugin", date = "2022-08-10T09:44:44.242978066+02:00[Europe/Paris]")
public final class JOSEConfigurationLoader extends ConfigurationLoaderSupport<JOSEConfiguration, JOSEConfigurationLoader.Configurator, JOSEConfigurationLoader> {

	public JOSEConfigurationLoader() {
		super(
			new String[] {
				"io.inverno.mod.security.jose.configuration.key_store",
				"io.inverno.mod.security.jose.configuration.key_store_type",
				"io.inverno.mod.security.jose.configuration.key_store_password",
				"io.inverno.mod.security.jose.configuration.resolve_jku",
				"io.inverno.mod.security.jose.configuration.trusted_jku",
				"io.inverno.mod.security.jose.configuration.resolve_x5u",
				"io.inverno.mod.security.jose.configuration.validate_certificate"
			},
			results -> configuration_configurator -> {
				results.get(0).getResult().ifPresent(property -> configuration_configurator.key_store(property.as(URI.class).orElse(null)));
				results.get(1).getResult().ifPresent(property -> configuration_configurator.key_store_type(property.as(String.class).orElse(null)));
				results.get(2).getResult().ifPresent(property -> configuration_configurator.key_store_password(property.as(String.class).orElse(null)));
				results.get(3).getResult().ifPresent(property -> configuration_configurator.resolve_jku(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(4).getResult().ifPresent(property -> configuration_configurator.trusted_jku(property.asSetOf(URI.class).orElse(null)));
				results.get(5).getResult().ifPresent(property -> configuration_configurator.resolve_x5u(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(6).getResult().ifPresent(property -> configuration_configurator.validate_certificate(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
			},
			JOSEConfigurationLoader::load,
			JOSEConfigurationLoader.Configuration::new
		);
	}

	public static JOSEConfiguration load(Consumer<JOSEConfigurationLoader.Configurator> configurer) {
		JOSEConfigurationLoader.Configurator configurator = new JOSEConfigurationLoader.Configurator();
		configurer.accept(configurator);
		return new JOSEConfigurationLoader.Configuration(configurator.key_store, configurator.key_store_type, configurator.key_store_password, configurator.resolve_jku, configurator.trusted_jku, configurator.resolve_x5u, configurator.validate_certificate);
	}

	private static final class Configuration implements JOSEConfiguration {

		private URI key_store;
		private String key_store_type = JOSEConfiguration.super.key_store_type();
		private String key_store_password;
		private boolean resolve_jku = JOSEConfiguration.super.resolve_jku();
		private Set<URI> trusted_jku = JOSEConfiguration.super.trusted_jku();
		private boolean resolve_x5u = JOSEConfiguration.super.resolve_x5u();
		private boolean validate_certificate = JOSEConfiguration.super.validate_certificate();

		private Configuration() {}

		public Configuration(Supplier<URI> key_store, Supplier<String> key_store_type, Supplier<String> key_store_password, Supplier<Boolean> resolve_jku, Supplier<Set<URI>> trusted_jku, Supplier<Boolean> resolve_x5u, Supplier<Boolean> validate_certificate) {
			Optional.ofNullable(key_store).ifPresent(s -> this.key_store = s.get());
			Optional.ofNullable(key_store_type).ifPresent(s -> this.key_store_type = s.get());
			Optional.ofNullable(key_store_password).ifPresent(s -> this.key_store_password = s.get());
			Optional.ofNullable(resolve_jku).ifPresent(s -> this.resolve_jku = s.get());
			Optional.ofNullable(trusted_jku).ifPresent(s -> this.trusted_jku = s.get());
			Optional.ofNullable(resolve_x5u).ifPresent(s -> this.resolve_x5u = s.get());
			Optional.ofNullable(validate_certificate).ifPresent(s -> this.validate_certificate = s.get());
		}

		public URI key_store() {
			 return this.key_store;
		}

		public String key_store_type() {
			 return this.key_store_type;
		}

		public String key_store_password() {
			 return this.key_store_password;
		}

		public boolean resolve_jku() {
			 return this.resolve_jku;
		}

		public Set<URI> trusted_jku() {
			 return this.trusted_jku;
		}

		public boolean resolve_x5u() {
			 return this.resolve_x5u;
		}

		public boolean validate_certificate() {
			 return this.validate_certificate;
		}
	}

	public static final class Configurator {

		private Supplier<URI> key_store;
		private Supplier<String> key_store_type;
		private Supplier<String> key_store_password;
		private Supplier<Boolean> resolve_jku;
		private Supplier<Set<URI>> trusted_jku;
		private Supplier<Boolean> resolve_x5u;
		private Supplier<Boolean> validate_certificate;

		private Configurator() {}

		public Configurator key_store(URI key_store) {
			this.key_store = () -> key_store;
			return this;
		}

		public Configurator key_store_type(String key_store_type) {
			this.key_store_type = () -> key_store_type;
			return this;
		}

		public Configurator key_store_password(String key_store_password) {
			this.key_store_password = () -> key_store_password;
			return this;
		}

		public Configurator resolve_jku(boolean resolve_jku) {
			this.resolve_jku = () -> resolve_jku;
			return this;
		}

		public Configurator trusted_jku(Set<URI> trusted_jku) {
			this.trusted_jku = () -> trusted_jku;
			return this;
		}

		public Configurator resolve_x5u(boolean resolve_x5u) {
			this.resolve_x5u = () -> resolve_x5u;
			return this;
		}

		public Configurator validate_certificate(boolean validate_certificate) {
			this.validate_certificate = () -> validate_certificate;
			return this;
		}
	}

	@io.inverno.core.annotation.Bean(name = "configuration")
	@Wrapper
	@Overridable
	public static final class Bean extends ConfigurationLoaderSupport.ConfigurationBeanSupport<JOSEConfiguration, JOSEConfigurationLoader.Configurator, JOSEConfigurationLoader> implements Supplier<JOSEConfiguration> {

		public Bean() {
			super(new JOSEConfigurationLoader());
		}

		public void setConfigurationSource(ConfigurationSource<?, ?, ?> source) {
			this.loader.withSource(source);
		}

		public void setParameters(Parameter[] parameters) {
			this.loader.withParameters(parameters);
		}

		public void setConfigurer(Consumer<JOSEConfigurationLoader.Configurator> configurer) {
			this.loader.withConfigurer(configurer);
		}
	}
}