/*
 * Decompiled with CFR 0.152.
 */
package io.infinitic.storage.inMemory;

import io.infinitic.common.storage.Flushable;
import io.infinitic.common.storage.keyValue.KeyValueStorage;
import io.infinitic.storage.inMemory.InMemoryStorage;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0019\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ!\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lio/infinitic/storage/inMemory/InMemoryStorage;", "Lio/infinitic/common/storage/keyValue/KeyValueStorage;", "Lio/infinitic/common/storage/Flushable;", "()V", "counterStorage", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/atomic/LongAdder;", "stateStorage", "Ljava/nio/ByteBuffer;", "deleteState", "", "key", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "flush", "getCounter", "", "getState", "incrementCounter", "amount", "(Ljava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "putState", "value", "(Ljava/lang/String;Ljava/nio/ByteBuffer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateState", "infinitic-storage"})
public final class InMemoryStorage
implements KeyValueStorage,
Flushable {
    private final ConcurrentHashMap<String, ByteBuffer> stateStorage = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LongAdder> counterStorage = new ConcurrentHashMap();

    @Nullable
    public Object getState(@NotNull String key, @NotNull Continuation<? super ByteBuffer> $completion) {
        return this.stateStorage.get(key);
    }

    @Nullable
    public Object putState(@NotNull String key, @NotNull ByteBuffer value, @NotNull Continuation<? super Unit> $completion) {
        ByteBuffer byteBuffer = ((Map)this.stateStorage).put(key, value);
        if (byteBuffer == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return byteBuffer;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object updateState(@NotNull String key, @NotNull ByteBuffer value, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.putState(key, value, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object deleteState(@NotNull String key, @NotNull Continuation<? super Unit> $completion) {
        ByteBuffer byteBuffer = this.stateStorage.remove(key);
        if (byteBuffer == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return byteBuffer;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object incrementCounter(@NotNull String key, long amount, @NotNull Continuation<? super Unit> $completion) {
        this.counterStorage.computeIfAbsent(key, incrementCounter.2.INSTANCE).add(amount);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object getCounter(@NotNull String key, @NotNull Continuation<? super Long> $completion) {
        return Boxing.boxLong((long)this.counterStorage.computeIfAbsent(key, getCounter.2.INSTANCE).sum());
    }

    public void flush() {
        this.stateStorage.clear();
        this.counterStorage.clear();
    }
}

