/*
 * Decompiled with CFR 0.152.
 */
package io.infinitic.storage.config;

import com.sksamuel.hoplite.Secret;
import io.infinitic.storage.config.PoolConfig;
import io.infinitic.storage.config.Redis;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 <2\u00020\u0001:\u0001<BY\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010)\u001a\u00020*J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\fH\u00c6\u0003J\t\u00102\u001a\u00020\u000eH\u00c6\u0003J]\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u00104\u001a\u00020\f2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u00106\u001a\u0002072\b\b\u0002\u00108\u001a\u000209J\t\u0010:\u001a\u00020\u0005H\u00d6\u0001J\t\u0010;\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010\u0013R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0015\"\u0004\b'\u0010(\u00a8\u0006="}, d2={"Lio/infinitic/storage/config/Redis;", "", "host", "", "port", "", "timeout", "user", "password", "Lcom/sksamuel/hoplite/Secret;", "database", "ssl", "", "poolConfig", "Lio/infinitic/storage/config/PoolConfig;", "(Ljava/lang/String;IILjava/lang/String;Lcom/sksamuel/hoplite/Secret;IZLio/infinitic/storage/config/PoolConfig;)V", "getDatabase", "()I", "setDatabase", "(I)V", "getHost", "()Ljava/lang/String;", "getPassword", "()Lcom/sksamuel/hoplite/Secret;", "setPassword", "(Lcom/sksamuel/hoplite/Secret;)V", "getPoolConfig", "()Lio/infinitic/storage/config/PoolConfig;", "setPoolConfig", "(Lio/infinitic/storage/config/PoolConfig;)V", "getPort", "setPort", "getSsl", "()Z", "setSsl", "(Z)V", "getTimeout", "setTimeout", "getUser", "setUser", "(Ljava/lang/String;)V", "close", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "getPool", "Lredis/clients/jedis/JedisPool;", "jedisPoolConfig", "Lredis/clients/jedis/JedisPoolConfig;", "hashCode", "toString", "Companion", "infinitic-storage"})
public final class Redis {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    private int port;
    private int timeout;
    @Nullable
    private String user;
    @Nullable
    private Secret password;
    private int database;
    private boolean ssl;
    @NotNull
    private PoolConfig poolConfig;
    @NotNull
    private static final ConcurrentHashMap<Redis, JedisPool> pools = new ConcurrentHashMap();

    public Redis(@NotNull String host, int port, int timeout, @Nullable String user, @Nullable Secret password, int database, boolean ssl, @NotNull PoolConfig poolConfig) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)poolConfig, (String)"poolConfig");
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.user = user;
        this.password = password;
        this.database = database;
        this.ssl = ssl;
        this.poolConfig = poolConfig;
    }

    public /* synthetic */ Redis(String string, int n, int n2, String string2, Secret secret, int n3, boolean bl, PoolConfig poolConfig, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            string = "127.0.0.1";
        }
        if ((n4 & 2) != 0) {
            n = 6379;
        }
        if ((n4 & 4) != 0) {
            n2 = 2000;
        }
        if ((n4 & 8) != 0) {
            string2 = null;
        }
        if ((n4 & 0x10) != 0) {
            secret = null;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x40) != 0) {
            bl = false;
        }
        if ((n4 & 0x80) != 0) {
            poolConfig = new PoolConfig(0, 0, 0, 7, null);
        }
        this(string, n, n2, string2, secret, n3, bl, poolConfig);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(int n) {
        this.timeout = n;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    public final void setUser(@Nullable String string) {
        this.user = string;
    }

    @Nullable
    public final Secret getPassword() {
        return this.password;
    }

    public final void setPassword(@Nullable Secret secret) {
        this.password = secret;
    }

    public final int getDatabase() {
        return this.database;
    }

    public final void setDatabase(int n) {
        this.database = n;
    }

    public final boolean getSsl() {
        return this.ssl;
    }

    public final void setSsl(boolean bl) {
        this.ssl = bl;
    }

    @NotNull
    public final PoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public final void setPoolConfig(@NotNull PoolConfig poolConfig) {
        Intrinsics.checkNotNullParameter((Object)poolConfig, (String)"<set-?>");
        this.poolConfig = poolConfig;
    }

    public final void close() {
        JedisPool jedisPool = pools.get(this);
        if (jedisPool != null) {
            jedisPool.close();
        }
        pools.remove(this);
    }

    @NotNull
    public final JedisPool getPool(@NotNull JedisPoolConfig jedisPoolConfig) {
        Intrinsics.checkNotNullParameter((Object)jedisPoolConfig, (String)"jedisPoolConfig");
        JedisPool jedisPool = pools.computeIfAbsent(this, arg_0 -> Redis.getPool$lambda$1((Function1)new Function1<Redis, JedisPool>(jedisPoolConfig){
            final /* synthetic */ JedisPoolConfig $jedisPoolConfig;
            {
                this.$jedisPoolConfig = $jedisPoolConfig;
                super(1);
            }

            @NotNull
            public final JedisPool invoke(@NotNull Redis it) {
                JedisPool jedisPool;
                JedisPool jedisPool2;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Secret secret = it.getPassword();
                CharSequence charSequence = secret != null ? secret.getValue() : null;
                boolean bl2 = bl = charSequence == null || charSequence.length() == 0;
                if (bl) {
                    jedisPool2 = new JedisPool((GenericObjectPoolConfig)this.$jedisPoolConfig, it.getHost(), it.getPort(), it.getDatabase());
                } else if (!bl) {
                    Secret secret2 = it.getPassword();
                    jedisPool2 = new JedisPool((GenericObjectPoolConfig)this.$jedisPoolConfig, it.getHost(), it.getPort(), it.getTimeout(), it.getUser(), secret2 != null ? secret2.getValue() : null, it.getDatabase(), it.getSsl());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                JedisPool pool = jedisPool = jedisPool2;
                boolean bl3 = false;
                Runtime.getRuntime().addShutdownHook(new Thread(() -> getPool.2.invoke$lambda$1$lambda$0(pool)));
                return jedisPool;
            }

            private static final void invoke$lambda$1$lambda$0(JedisPool $pool) {
                Intrinsics.checkNotNullParameter((Object)$pool, (String)"$pool");
                $pool.close();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jedisPool, (String)"computeIfAbsent(...)");
        return jedisPool;
    }

    public static /* synthetic */ JedisPool getPool$default(Redis redis, JedisPoolConfig jedisPoolConfig, int n, Object object) {
        if ((n & 1) != 0) {
            JedisPoolConfig jedisPoolConfig2;
            JedisPoolConfig it = jedisPoolConfig2 = new JedisPoolConfig();
            boolean bl = false;
            it.setMaxTotal(redis.poolConfig.getMaxTotal());
            it.setMaxIdle(redis.poolConfig.getMaxIdle());
            it.setMinIdle(redis.poolConfig.getMinIdle());
            jedisPoolConfig = jedisPoolConfig2;
        }
        return redis.getPool(jedisPoolConfig);
    }

    @NotNull
    public final String component1() {
        return this.host;
    }

    public final int component2() {
        return this.port;
    }

    public final int component3() {
        return this.timeout;
    }

    @Nullable
    public final String component4() {
        return this.user;
    }

    @Nullable
    public final Secret component5() {
        return this.password;
    }

    public final int component6() {
        return this.database;
    }

    public final boolean component7() {
        return this.ssl;
    }

    @NotNull
    public final PoolConfig component8() {
        return this.poolConfig;
    }

    @NotNull
    public final Redis copy(@NotNull String host, int port, int timeout, @Nullable String user, @Nullable Secret password, int database, boolean ssl, @NotNull PoolConfig poolConfig) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)poolConfig, (String)"poolConfig");
        return new Redis(host, port, timeout, user, password, database, ssl, poolConfig);
    }

    public static /* synthetic */ Redis copy$default(Redis redis, String string, int n, int n2, String string2, Secret secret, int n3, boolean bl, PoolConfig poolConfig, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = redis.host;
        }
        if ((n4 & 2) != 0) {
            n = redis.port;
        }
        if ((n4 & 4) != 0) {
            n2 = redis.timeout;
        }
        if ((n4 & 8) != 0) {
            string2 = redis.user;
        }
        if ((n4 & 0x10) != 0) {
            secret = redis.password;
        }
        if ((n4 & 0x20) != 0) {
            n3 = redis.database;
        }
        if ((n4 & 0x40) != 0) {
            bl = redis.ssl;
        }
        if ((n4 & 0x80) != 0) {
            poolConfig = redis.poolConfig;
        }
        return redis.copy(string, n, n2, string2, secret, n3, bl, poolConfig);
    }

    @NotNull
    public String toString() {
        return "Redis(host=" + this.host + ", port=" + this.port + ", timeout=" + this.timeout + ", user=" + this.user + ", password=" + this.password + ", database=" + this.database + ", ssl=" + this.ssl + ", poolConfig=" + this.poolConfig + ")";
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = result * 31 + Integer.hashCode(this.port);
        result = result * 31 + Integer.hashCode(this.timeout);
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + Integer.hashCode(this.database);
        result = result * 31 + Boolean.hashCode(this.ssl);
        result = result * 31 + this.poolConfig.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Redis)) {
            return false;
        }
        Redis redis = (Redis)other;
        if (!Intrinsics.areEqual((Object)this.host, (Object)redis.host)) {
            return false;
        }
        if (this.port != redis.port) {
            return false;
        }
        if (this.timeout != redis.timeout) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.user, (Object)redis.user)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.password, (Object)redis.password)) {
            return false;
        }
        if (this.database != redis.database) {
            return false;
        }
        if (this.ssl != redis.ssl) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.poolConfig, (Object)redis.poolConfig);
    }

    private static final JedisPool getPool$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JedisPool)$tmp0.invoke(p0);
    }

    public Redis() {
        this(null, 0, 0, null, null, 0, false, null, 255, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lio/infinitic/storage/config/Redis$Companion;", "", "()V", "pools", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/infinitic/storage/config/Redis;", "Lredis/clients/jedis/JedisPool;", "getPools", "()Ljava/util/concurrent/ConcurrentHashMap;", "close", "", "infinitic-storage"})
    @SourceDebugExtension(value={"SMAP\nRedis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Redis.kt\nio/infinitic/storage/config/Redis$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1855#2,2:81\n*S KotlinDebug\n*F\n+ 1 Redis.kt\nio/infinitic/storage/config/Redis$Companion\n*L\n45#1:81,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConcurrentHashMap<Redis, JedisPool> getPools() {
            return pools;
        }

        public final void close() {
            Set set = this.getPools().keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Redis it = (Redis)element$iv;
                boolean bl = false;
                it.close();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

