/*
 * Decompiled with CFR 0.152.
 */
package io.infinitic.storage.compressor;

import io.infinitic.storage.compressor.Compressor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0086\u0001\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lio/infinitic/storage/compressor/Compressor;", "", "(Ljava/lang/String;I)V", "compress", "", "data", "gzip", "bzip2", "deflate", "Companion", "infinitic-storage"})
@SourceDebugExtension(value={"SMAP\nCompressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Compressor.kt\nio/infinitic/storage/compressor/Compressor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public class Compressor
extends Enum<Compressor> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final KLogger logger;
    public static final /* enum */ Compressor gzip;
    public static final /* enum */ Compressor bzip2;
    public static final /* enum */ Compressor deflate;
    private static final /* synthetic */ Compressor[] $VALUES;

    private Compressor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] compress(@NotNull byte[] data) {
        Object it2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Closeable closeable = (Closeable)new CompressorStreamFactory().createCompressorOutputStream(this.toString(), (OutputStream)out);
        Object object = null;
        try {
            it2 = (CompressorOutputStream)closeable;
            boolean bl = false;
            it2.write(data);
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            object = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        object = out.toByteArray();
        it2 = object;
        boolean bl = false;
        out.close();
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"out.toByteArray().also { out.close() }");
        return object2;
    }

    public static Compressor[] values() {
        return (Compressor[])$VALUES.clone();
    }

    public static Compressor valueOf(String value) {
        return Enum.valueOf(Compressor.class, value);
    }

    public /* synthetic */ Compressor(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        gzip = new gzip("gzip", 0);
        bzip2 = new bzip2("bzip2", 1);
        deflate = new deflate("deflate", 2);
        $VALUES = compressorArray = new Compressor[]{Compressor.gzip, Compressor.bzip2, Compressor.deflate};
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/infinitic/storage/compressor/Compressor$Companion;", "", "()V", "logger", "Lmu/KLogger;", "decompress", "", "data", "infinitic-storage"})
    @SourceDebugExtension(value={"SMAP\nCompressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Compressor.kt\nio/infinitic/storage/compressor/Compressor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] decompress(@NotNull byte[] data) {
            Object it2;
            Object object;
            String string;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            ByteArrayInputStream input = new ByteArrayInputStream(data);
            try {
                string = CompressorStreamFactory.detect((InputStream)input);
            }
            catch (CompressorException e) {
                return data;
            }
            String type2 = string;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                Closeable e = (Closeable)new CompressorStreamFactory().createCompressorInputStream(type2, (InputStream)input);
                object = null;
                try {
                    it2 = (CompressorInputStream)e;
                    boolean bl = false;
                    out.write(it2.readAllBytes());
                    it2 = Unit.INSTANCE;
                }
                catch (Throwable it2) {
                    object = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)e, (Throwable)object);
                }
            }
            catch (Exception e) {
                byte[] byArray;
                logger.warn((Function0)new Function0<Object>(type2, e){
                    final /* synthetic */ String $type;
                    final /* synthetic */ Exception $e;
                    {
                        this.$type = $type;
                        this.$e = $e;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Error when decompressing data with '" + this.$type + "' algorithm, fallback to not decompressing\n" + this.$e.getMessage();
                    }
                });
                byte[] it3 = byArray = data;
                boolean bl = false;
                out.close();
                return byArray;
            }
            object = out.toByteArray();
            it2 = object;
            boolean bl = false;
            out.close();
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"out.toByteArray().also { out.close() }");
            return object2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lio/infinitic/storage/compressor/Compressor$bzip2;", "Lio/infinitic/storage/compressor/Compressor;", "toString", "", "infinitic-storage"})
    static final class bzip2
    extends Compressor {
        /*
         * WARNING - void declaration
         */
        bzip2() {
            void var1_1;
        }

        @NotNull
        public String toString() {
            return "bzip2";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lio/infinitic/storage/compressor/Compressor$deflate;", "Lio/infinitic/storage/compressor/Compressor;", "toString", "", "infinitic-storage"})
    static final class deflate
    extends Compressor {
        /*
         * WARNING - void declaration
         */
        deflate() {
            void var1_1;
        }

        @NotNull
        public String toString() {
            return "deflate";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lio/infinitic/storage/compressor/Compressor$gzip;", "Lio/infinitic/storage/compressor/Compressor;", "toString", "", "infinitic-storage"})
    static final class gzip
    extends Compressor {
        /*
         * WARNING - void declaration
         */
        gzip() {
            void var1_1;
        }

        @NotNull
        public String toString() {
            return "gz";
        }
    }
}

