/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.util;

import io.indextables.tantivy4java.core.Tantivy;
import java.util.List;

public class TextAnalyzer
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    TextAnalyzer(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public static TextAnalyzer create(String tokenizerName) {
        long ptr = TextAnalyzer.nativeCreateAnalyzer(tokenizerName);
        return new TextAnalyzer(ptr);
    }

    public static List<String> tokenize(String text) {
        return TextAnalyzer.tokenize(text, "default");
    }

    public static List<String> tokenize(String text, String tokenizerName) {
        return TextAnalyzer.nativeTokenize(text, tokenizerName);
    }

    public List<String> analyze(String text) {
        if (this.closed) {
            throw new IllegalStateException("TextAnalyzer has been closed");
        }
        return TextAnalyzer.nativeAnalyze(this.nativePtr, text);
    }

    public long getNativePtr() {
        if (this.closed) {
            throw new IllegalStateException("TextAnalyzer has been closed");
        }
        return this.nativePtr;
    }

    @Override
    public void close() {
        if (!this.closed) {
            TextAnalyzer.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    private static native long nativeCreateAnalyzer(String var0);

    private static native List<String> nativeTokenize(String var0, String var1);

    private static native List<String> nativeAnalyze(long var0, String var2);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }
}

