/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.util;

import io.indextables.tantivy4java.core.Tantivy;
import java.util.List;

public class Facet
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    public static Facet fromEncoded(byte[] encodedBytes) {
        long ptr = Facet.nativeFromEncoded(encodedBytes);
        return new Facet(ptr);
    }

    public static Facet root() {
        long ptr = Facet.nativeRoot();
        return new Facet(ptr);
    }

    public static Facet fromString(String facetString) {
        long ptr = Facet.nativeFromString(facetString);
        return new Facet(ptr);
    }

    Facet(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public boolean isRoot() {
        if (this.closed) {
            throw new IllegalStateException("Facet has been closed");
        }
        return Facet.nativeIsRoot(this.nativePtr);
    }

    public boolean isPrefixOf(Facet other) {
        if (this.closed) {
            throw new IllegalStateException("Facet has been closed");
        }
        return Facet.nativeIsPrefixOf(this.nativePtr, other.getNativePtr());
    }

    public List<String> toPath() {
        if (this.closed) {
            throw new IllegalStateException("Facet has been closed");
        }
        return Facet.nativeToPath(this.nativePtr);
    }

    public String toPathStr() {
        if (this.closed) {
            throw new IllegalStateException("Facet has been closed");
        }
        return Facet.nativeToPathStr(this.nativePtr);
    }

    public long getNativePtr() {
        if (this.closed) {
            throw new IllegalStateException("Facet has been closed");
        }
        return this.nativePtr;
    }

    @Override
    public void close() {
        if (!this.closed) {
            Facet.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    public String toString() {
        return this.toPathStr();
    }

    private static native long nativeFromEncoded(byte[] var0);

    private static native long nativeRoot();

    private static native long nativeFromString(String var0);

    private static native boolean nativeIsRoot(long var0);

    private static native boolean nativeIsPrefixOf(long var0, long var2);

    private static native List<String> nativeToPath(long var0);

    private static native String nativeToPathStr(long var0);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }
}

