/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.split.merge;

import io.indextables.tantivy4java.split.merge.QuickwitSplit;
import java.util.List;

public class QuickwitSplitInspector {
    public static void main(String[] args) {
        try {
            String splitPath = "/tmp/splitexample/example_index.split";
            System.out.println("\ud83d\udd0d Inspecting QuickwitSplit file: " + splitPath);
            System.out.println("==============================================");
            QuickwitSplit.SplitMetadata metadata = QuickwitSplit.readSplitMetadata(splitPath);
            System.out.println("\ud83d\udcca Split Metadata:");
            System.out.println("  - Split ID: " + metadata.getSplitId());
            System.out.println("  - Document Count: " + metadata.getNumDocs());
            System.out.println("  - Uncompressed Size: " + metadata.getUncompressedSizeBytes() + " bytes");
            System.out.println("  - Time Range Start: " + String.valueOf(metadata.getTimeRangeStart()));
            System.out.println("  - Time Range End: " + String.valueOf(metadata.getTimeRangeEnd()));
            System.out.println("  - Tags: " + String.valueOf(metadata.getTags()));
            System.out.println("  - Delete Opstamp: " + metadata.getDeleteOpstamp());
            System.out.println("  - Merge Operations: " + metadata.getNumMergeOps());
            System.out.println("\n\ud83d\udcc2 Files in split:");
            List<String> splitFiles = QuickwitSplit.listSplitFiles(splitPath);
            for (String file : splitFiles) {
                System.out.println("  - " + file);
            }
            boolean isValid = QuickwitSplit.validateSplit(splitPath);
            System.out.println("\n\u2705 Split validation: " + (isValid ? "PASSED" : "FAILED"));
            System.out.println("\n\ud83c\udf89 Split inspection completed successfully!");
        }
        catch (Exception e) {
            System.err.println("\u274c Error inspecting split: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

