/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.split.merge;

import io.indextables.tantivy4java.config.FileSystemConfig;
import io.indextables.tantivy4java.core.Index;
import io.indextables.tantivy4java.core.Tantivy;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QuickwitSplit {
    public static SplitMetadata convertIndex(Index index, String outputPath, SplitConfig config) {
        String resolvedOutputPath;
        if (outputPath == null || !outputPath.endsWith(".split")) {
            throw new IllegalArgumentException("Output path must end with .split");
        }
        if (config == null) {
            throw new IllegalArgumentException("Split configuration cannot be null");
        }
        String string = resolvedOutputPath = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(outputPath) : outputPath;
        if (config.getIndexUid() == null || config.getIndexUid().trim().isEmpty()) {
            throw new IllegalArgumentException("Index UID cannot be null or empty");
        }
        if (config.getSourceId() == null || config.getSourceId().trim().isEmpty()) {
            throw new IllegalArgumentException("Source ID cannot be null or empty");
        }
        if (config.getNodeId() == null || config.getNodeId().trim().isEmpty()) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        String indexPath = index.getIndexPath();
        if (indexPath != null) {
            return QuickwitSplit.convertIndexFromPath(indexPath, resolvedOutputPath, config);
        }
        throw new IllegalArgumentException("Cannot convert in-memory index to Quickwit split. For in-memory indices, first save the index to disk using IndexWriter.commit(), then use QuickwitSplit.convertIndexFromPath(indexPath, outputPath, config) instead.");
    }

    public static SplitMetadata convertIndexFromPath(String indexPath, String outputPath, SplitConfig config) {
        if (indexPath == null || indexPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Index path cannot be null or empty");
        }
        if (outputPath == null || !outputPath.endsWith(".split")) {
            throw new IllegalArgumentException("Output path must end with .split");
        }
        if (config == null) {
            throw new IllegalArgumentException("Split configuration cannot be null");
        }
        String resolvedIndexPath = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(indexPath) : indexPath;
        String resolvedOutputPath = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(outputPath) : outputPath;
        return QuickwitSplit.nativeConvertIndexFromPath(resolvedIndexPath, resolvedOutputPath, config);
    }

    public static SplitMetadata readSplitMetadata(String splitPath) {
        if (splitPath == null || splitPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Split path cannot be null or empty");
        }
        if (!splitPath.endsWith(".split")) {
            throw new IllegalArgumentException("Split path must end with .split");
        }
        String resolvedSplitPath = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(splitPath) : splitPath;
        return QuickwitSplit.nativeReadSplitMetadata(resolvedSplitPath);
    }

    public static List<String> listSplitFiles(String splitPath) {
        if (splitPath == null || splitPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Split path cannot be null or empty");
        }
        if (!splitPath.endsWith(".split")) {
            throw new IllegalArgumentException("Split path must end with .split");
        }
        String resolvedSplitPath = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(splitPath) : splitPath;
        return QuickwitSplit.nativeListSplitFiles(resolvedSplitPath);
    }

    public static SplitMetadata extractSplit(String splitPath, String outputDir) {
        if (splitPath == null || splitPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Split path cannot be null or empty");
        }
        if (!splitPath.endsWith(".split")) {
            throw new IllegalArgumentException("Split path must end with .split");
        }
        if (outputDir == null || outputDir.trim().isEmpty()) {
            throw new IllegalArgumentException("Output directory cannot be null or empty");
        }
        String resolvedSplitPath = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(splitPath) : splitPath;
        String resolvedOutputDir = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(outputDir) : outputDir;
        return QuickwitSplit.nativeExtractSplit(resolvedSplitPath, resolvedOutputDir);
    }

    public static boolean validateSplit(String splitPath) {
        if (splitPath == null || splitPath.trim().isEmpty() || !splitPath.endsWith(".split")) {
            return false;
        }
        try {
            String resolvedSplitPath = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(splitPath) : splitPath;
            return QuickwitSplit.nativeValidateSplit(resolvedSplitPath);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static SplitMetadata mergeSplits(List<String> splitUrls, String outputPath, MergeConfig config) {
        if (splitUrls == null || splitUrls.isEmpty()) {
            throw new IllegalArgumentException("Split URLs list cannot be null or empty");
        }
        if (splitUrls.size() < 2) {
            throw new IllegalArgumentException("At least 2 splits are required for merging");
        }
        if (outputPath == null || !outputPath.endsWith(".split")) {
            throw new IllegalArgumentException("Output path must end with .split");
        }
        if (config == null) {
            throw new IllegalArgumentException("Merge configuration cannot be null");
        }
        if (config.getIndexUid() == null || config.getIndexUid().trim().isEmpty()) {
            throw new IllegalArgumentException("Index UID cannot be null or empty");
        }
        if (config.getSourceId() == null || config.getSourceId().trim().isEmpty()) {
            throw new IllegalArgumentException("Source ID cannot be null or empty");
        }
        if (config.getNodeId() == null || config.getNodeId().trim().isEmpty()) {
            throw new IllegalArgumentException("Node ID cannot be null or empty");
        }
        for (String splitUrl : splitUrls) {
            if (splitUrl == null || splitUrl.trim().isEmpty()) {
                throw new IllegalArgumentException("Split URL cannot be null or empty");
            }
            if (splitUrl.contains("://") || splitUrl.endsWith(".split")) continue;
            throw new IllegalArgumentException("Split file path must end with .split: " + splitUrl);
        }
        String resolvedOutputPath = outputPath;
        if (!outputPath.contains("://")) {
            resolvedOutputPath = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(outputPath) : outputPath;
        }
        ArrayList<String> resolvedSplitUrls = new ArrayList<String>();
        for (String splitUrl : splitUrls) {
            if (!splitUrl.contains("://")) {
                resolvedSplitUrls.add(FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(splitUrl) : splitUrl);
                continue;
            }
            resolvedSplitUrls.add(splitUrl);
        }
        return QuickwitSplit.nativeMergeSplits(resolvedSplitUrls, resolvedOutputPath, config);
    }

    private static native SplitMetadata nativeConvertIndex(long var0, String var2, SplitConfig var3);

    private static native SplitMetadata nativeConvertIndexFromPath(String var0, String var1, SplitConfig var2);

    private static native SplitMetadata nativeReadSplitMetadata(String var0);

    private static native List<String> nativeListSplitFiles(String var0);

    private static native SplitMetadata nativeExtractSplit(String var0, String var1);

    private static native boolean nativeValidateSplit(String var0);

    private static native SplitMetadata nativeMergeSplits(List<String> var0, String var1, MergeConfig var2);

    static {
        Tantivy.initialize();
    }

    public static class MergeConfig {
        private final String indexUid;
        private final String sourceId;
        private final String nodeId;
        private final String docMappingUid;
        private final long partitionId;
        private final List<String> deleteQueries;
        private final AwsConfig awsConfig;
        private final String tempDirectoryPath;
        private final Long heapSizeBytes;
        private final boolean debugEnabled;

        public MergeConfig(String indexUid, String sourceId, String nodeId, String docMappingUid, long partitionId, List<String> deleteQueries, AwsConfig awsConfig, String tempDirectoryPath, Long heapSizeBytes, boolean debugEnabled) {
            this.indexUid = indexUid;
            this.sourceId = sourceId;
            this.nodeId = nodeId;
            this.docMappingUid = docMappingUid;
            this.partitionId = partitionId;
            this.deleteQueries = deleteQueries;
            this.awsConfig = awsConfig;
            this.tempDirectoryPath = tempDirectoryPath;
            this.heapSizeBytes = heapSizeBytes;
            this.debugEnabled = debugEnabled;
        }

        public MergeConfig(String indexUid, String sourceId, String nodeId, String docMappingUid, long partitionId, List<String> deleteQueries, AwsConfig awsConfig) {
            this(indexUid, sourceId, nodeId, docMappingUid, partitionId, deleteQueries, awsConfig, null, null, false);
        }

        public MergeConfig(String indexUid, String sourceId, String nodeId, String docMappingUid, long partitionId, List<String> deleteQueries) {
            this(indexUid, sourceId, nodeId, docMappingUid, partitionId, deleteQueries, null, null, null, false);
        }

        public MergeConfig(String indexUid, String sourceId, String nodeId) {
            this(indexUid, sourceId, nodeId, "default", 0L, null, null, null, null, false);
        }

        public MergeConfig(String indexUid, String sourceId, String nodeId, AwsConfig awsConfig) {
            this(indexUid, sourceId, nodeId, "default", 0L, null, awsConfig, null, null, false);
        }

        public MergeConfig(String indexUid, String sourceId, String nodeId, AwsConfig awsConfig, String tempDirectoryPath) {
            this(indexUid, sourceId, nodeId, "default", 0L, null, awsConfig, tempDirectoryPath, null, false);
        }

        public MergeConfig(String indexUid, String sourceId, String nodeId, Long heapSizeBytes) {
            this(indexUid, sourceId, nodeId, "default", 0L, null, null, null, heapSizeBytes, false);
        }

        public MergeConfig(String indexUid, String sourceId, String nodeId, AwsConfig awsConfig, boolean debugEnabled) {
            this(indexUid, sourceId, nodeId, "default", 0L, null, awsConfig, null, null, debugEnabled);
        }

        public String getIndexUid() {
            return this.indexUid;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getDocMappingUid() {
            return this.docMappingUid;
        }

        public long getPartitionId() {
            return this.partitionId;
        }

        public List<String> getDeleteQueries() {
            return this.deleteQueries;
        }

        public AwsConfig getAwsConfig() {
            return this.awsConfig;
        }

        public String getTempDirectoryPath() {
            return this.tempDirectoryPath;
        }

        public Long getHeapSizeBytes() {
            return this.heapSizeBytes;
        }

        public boolean isDebugEnabled() {
            return this.debugEnabled;
        }
    }

    public static class AwsConfig {
        private final String accessKey;
        private final String secretKey;
        private final String sessionToken;
        private final String region;
        private final String endpoint;
        private final boolean forcePathStyle;

        public AwsConfig(String accessKey, String secretKey, String region) {
            this(accessKey, secretKey, null, region, null, false);
        }

        public AwsConfig(String accessKey, String secretKey, String sessionToken, String region, String endpoint, boolean forcePathStyle) {
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.sessionToken = sessionToken;
            this.region = region;
            this.endpoint = endpoint;
            this.forcePathStyle = forcePathStyle;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public String getRegion() {
            return this.region;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public boolean isForcePathStyle() {
            return this.forcePathStyle;
        }
    }

    public static class SplitMetadata {
        private final String splitId;
        private final String indexUid;
        private final long partitionId;
        private final String sourceId;
        private final String nodeId;
        private final long numDocs;
        private final long uncompressedSizeBytes;
        private final Instant timeRangeStart;
        private final Instant timeRangeEnd;
        private final long createTimestamp;
        private final String maturity;
        private final Set<String> tags;
        private final long footerStartOffset;
        private final long footerEndOffset;
        private final long deleteOpstamp;
        private final int numMergeOps;
        private final String docMappingUid;
        @Deprecated
        private final long hotcacheStartOffset;
        @Deprecated
        private final long hotcacheLength;
        @Deprecated
        private final String docMappingJson;
        private final List<String> skippedSplits;

        public SplitMetadata(String splitId, String indexUid, long partitionId, String sourceId, String nodeId, long numDocs, long uncompressedSizeBytes, Instant timeRangeStart, Instant timeRangeEnd, long createTimestamp, String maturity, Set<String> tags, long footerStartOffset, long footerEndOffset, long deleteOpstamp, int numMergeOps, String docMappingUid, String docMappingJson, List<String> skippedSplits) {
            this.splitId = splitId;
            this.indexUid = indexUid;
            this.partitionId = partitionId;
            this.sourceId = sourceId;
            this.nodeId = nodeId;
            this.numDocs = numDocs;
            this.uncompressedSizeBytes = uncompressedSizeBytes;
            this.timeRangeStart = timeRangeStart;
            this.timeRangeEnd = timeRangeEnd;
            this.createTimestamp = createTimestamp;
            this.maturity = maturity;
            this.tags = tags != null ? new HashSet<String>(tags) : new HashSet();
            this.footerStartOffset = footerStartOffset;
            this.footerEndOffset = footerEndOffset;
            this.deleteOpstamp = deleteOpstamp;
            this.numMergeOps = numMergeOps;
            this.docMappingUid = docMappingUid;
            this.hotcacheStartOffset = -1L;
            this.hotcacheLength = -1L;
            this.docMappingJson = docMappingJson;
            this.skippedSplits = skippedSplits != null ? new ArrayList<String>(skippedSplits) : new ArrayList();
        }

        @Deprecated
        public SplitMetadata(String splitId, long numDocs, long uncompressedSizeBytes, Instant timeRangeStart, Instant timeRangeEnd, Set<String> tags, long deleteOpstamp, int numMergeOps, long footerStartOffset, long footerEndOffset, long hotcacheStartOffset, long hotcacheLength, String docMappingJson, List<String> skippedSplits) {
            this(splitId, "unknown-index", 0L, "unknown-source", "unknown-node", numDocs, uncompressedSizeBytes, timeRangeStart, timeRangeEnd, System.currentTimeMillis() / 1000L, "Mature", tags, footerStartOffset, footerEndOffset, deleteOpstamp, numMergeOps, "unknown-doc-mapping", docMappingJson, skippedSplits);
        }

        @Deprecated
        public SplitMetadata(String splitId, long numDocs, long uncompressedSizeBytes, Instant timeRangeStart, Instant timeRangeEnd, Set<String> tags, long deleteOpstamp, int numMergeOps) {
            this(splitId, "unknown-index", 0L, "unknown-source", "unknown-node", numDocs, uncompressedSizeBytes, timeRangeStart, timeRangeEnd, System.currentTimeMillis() / 1000L, "Mature", tags, -1L, -1L, deleteOpstamp, numMergeOps, "unknown-doc-mapping", null, null);
        }

        @Deprecated
        public SplitMetadata(long footerStartOffset, long footerEndOffset, long hotcacheStartOffset, long hotcacheLength) {
            this("", "test-index", 0L, "test-source", "test-node", 0L, 0L, null, null, System.currentTimeMillis() / 1000L, "Mature", new HashSet<String>(), footerStartOffset, footerEndOffset, 0L, 0, "test-doc-mapping", null, null);
        }

        public String getSplitId() {
            return this.splitId;
        }

        public String getIndexUid() {
            return this.indexUid;
        }

        public long getPartitionId() {
            return this.partitionId;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public long getNumDocs() {
            return this.numDocs;
        }

        public long getUncompressedSizeBytes() {
            return this.uncompressedSizeBytes;
        }

        public Instant getTimeRangeStart() {
            return this.timeRangeStart;
        }

        public Instant getTimeRangeEnd() {
            return this.timeRangeEnd;
        }

        public long getCreateTimestamp() {
            return this.createTimestamp;
        }

        public String getMaturity() {
            return this.maturity;
        }

        public Set<String> getTags() {
            return new HashSet<String>(this.tags);
        }

        public long getFooterStartOffset() {
            return this.footerStartOffset;
        }

        public long getFooterEndOffset() {
            return this.footerEndOffset;
        }

        public long getDeleteOpstamp() {
            return this.deleteOpstamp;
        }

        public int getNumMergeOps() {
            return this.numMergeOps;
        }

        public String getDocMappingUid() {
            return this.docMappingUid;
        }

        @Deprecated
        public long getHotcacheStartOffset() {
            throw new UnsupportedOperationException("Hotcache offsets not supported in Quickwit format. Use footer offsets instead.");
        }

        @Deprecated
        public long getHotcacheLength() {
            throw new UnsupportedOperationException("Hotcache length not supported in Quickwit format. Use footer offsets instead.");
        }

        @Deprecated
        public String getDocMappingJson() {
            return this.docMappingJson;
        }

        public List<String> getSkippedSplits() {
            return new ArrayList<String>(this.skippedSplits);
        }

        public boolean hasFooterOffsets() {
            return this.footerStartOffset >= 0L && this.footerEndOffset >= 0L;
        }

        public boolean hasTimeRange() {
            return this.timeRangeStart != null && this.timeRangeEnd != null;
        }

        public boolean isImmature() {
            return "Immature".equals(this.maturity);
        }

        public boolean isMature() {
            return "Mature".equals(this.maturity);
        }

        @Deprecated
        public boolean hasDocMapping() {
            return false;
        }

        public boolean hasSkippedSplits() {
            return !this.skippedSplits.isEmpty();
        }

        public long getMetadataSize() {
            return this.hasFooterOffsets() ? this.footerEndOffset - this.footerStartOffset : -1L;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SplitMetadata{").append("splitId='").append(this.splitId).append('\'').append(", indexUid='").append(this.indexUid).append('\'').append(", sourceId='").append(this.sourceId).append('\'').append(", nodeId='").append(this.nodeId).append('\'').append(", partitionId=").append(this.partitionId).append(", numDocs=").append(this.numDocs).append(", uncompressedSizeBytes=").append(this.uncompressedSizeBytes).append(", timeRangeStart=").append(this.timeRangeStart).append(", timeRangeEnd=").append(this.timeRangeEnd).append(", createTimestamp=").append(this.createTimestamp).append(", maturity='").append(this.maturity).append('\'').append(", tags=").append(this.tags).append(", deleteOpstamp=").append(this.deleteOpstamp).append(", numMergeOps=").append(this.numMergeOps).append(", docMappingUid='").append(this.docMappingUid).append('\'').append(", footerOffsets=").append(this.footerStartOffset).append("-").append(this.footerEndOffset);
            if (this.hasSkippedSplits()) {
                sb.append(", skippedSplits=").append(this.skippedSplits.size()).append(" splits");
            }
            return sb.append('}').toString();
        }
    }

    public static class SplitConfig {
        private final String indexUid;
        private final String sourceId;
        private final String nodeId;
        private final String docMappingUid;
        private final long partitionId;
        private final Instant timeRangeStart;
        private final Instant timeRangeEnd;
        private final Set<String> tags;
        private final Map<String, Object> metadata;
        private final long streamingChunkSize;
        private final boolean enableProgressTracking;
        private final boolean enableStreamingIO;

        public SplitConfig(String indexUid, String sourceId, String nodeId, String docMappingUid, long partitionId, Instant timeRangeStart, Instant timeRangeEnd, Set<String> tags, Map<String, Object> metadata) {
            this(indexUid, sourceId, nodeId, docMappingUid, partitionId, timeRangeStart, timeRangeEnd, tags, metadata, 64000000L, false, true);
        }

        public SplitConfig(String indexUid, String sourceId, String nodeId, String docMappingUid, long partitionId, Instant timeRangeStart, Instant timeRangeEnd, Set<String> tags, Map<String, Object> metadata, long streamingChunkSize, boolean enableProgressTracking, boolean enableStreamingIO) {
            this.indexUid = indexUid;
            this.sourceId = sourceId;
            this.nodeId = nodeId;
            this.docMappingUid = docMappingUid;
            this.partitionId = partitionId;
            this.timeRangeStart = timeRangeStart;
            this.timeRangeEnd = timeRangeEnd;
            this.tags = tags;
            this.metadata = metadata;
            this.streamingChunkSize = streamingChunkSize;
            this.enableProgressTracking = enableProgressTracking;
            this.enableStreamingIO = enableStreamingIO;
        }

        public SplitConfig(String indexUid, String sourceId, String nodeId) {
            this(indexUid, sourceId, nodeId, "default", 0L, null, null, null, null, 64000000L, false, true);
        }

        public String getIndexUid() {
            return this.indexUid;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getDocMappingUid() {
            return this.docMappingUid;
        }

        public long getPartitionId() {
            return this.partitionId;
        }

        public Instant getTimeRangeStart() {
            return this.timeRangeStart;
        }

        public Instant getTimeRangeEnd() {
            return this.timeRangeEnd;
        }

        public Set<String> getTags() {
            return this.tags;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public long getStreamingChunkSize() {
            return this.streamingChunkSize;
        }

        public boolean isProgressTrackingEnabled() {
            return this.enableProgressTracking;
        }

        public boolean isStreamingIOEnabled() {
            return this.enableStreamingIO;
        }
    }
}

