/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.split;

import io.indextables.tantivy4java.core.DocAddress;
import io.indextables.tantivy4java.core.Document;
import io.indextables.tantivy4java.core.Schema;
import io.indextables.tantivy4java.core.Tantivy;
import io.indextables.tantivy4java.query.Query;
import io.indextables.tantivy4java.result.SearchResult;
import io.indextables.tantivy4java.split.SplitAggregation;
import io.indextables.tantivy4java.split.SplitCacheManager;
import io.indextables.tantivy4java.split.SplitQuery;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class SplitSearcher
implements AutoCloseable {
    private long nativePtr;
    private final String splitPath;
    private final SplitCacheManager cacheManager;

    SplitSearcher(String splitPath, SplitCacheManager cacheManager, Map<String, Object> splitConfig) {
        this.splitPath = splitPath;
        this.cacheManager = cacheManager;
        this.nativePtr = SplitSearcher.createNativeWithSharedCache(splitPath, cacheManager.getNativePtr(), splitConfig);
    }

    @Deprecated
    private static SplitSearcher create(String splitPath) {
        throw new UnsupportedOperationException("SplitSearcher.create() is deprecated. Use SplitCacheManager.createSplitSearcher() instead. Create a SplitCacheManager with proper configuration and use it to create searchers.");
    }

    public Schema getSchema() {
        System.out.println("\ud83d\udd0d Java SplitSearcher.getSchema called with nativePtr=" + this.nativePtr);
        long schemaPtr = SplitSearcher.getSchemaFromNative(this.nativePtr);
        System.out.println("\ud83d\udd0d Java getSchemaFromNative returned schemaPtr=" + schemaPtr);
        return new Schema(schemaPtr);
    }

    public SplitQuery parseQuery(String queryString) {
        if (queryString == null || queryString.trim().isEmpty()) {
            throw new IllegalArgumentException("Query string cannot be null or empty");
        }
        Schema schema = this.getSchema();
        return SplitQuery.parseQuery(queryString, schema);
    }

    public SplitQuery parseQuery(String queryString, List<String> defaultFieldNames) {
        if (queryString == null || queryString.trim().isEmpty()) {
            throw new IllegalArgumentException("Query string cannot be null or empty");
        }
        if (defaultFieldNames == null) {
            defaultFieldNames = Collections.emptyList();
        }
        String[] defaultFieldArray = defaultFieldNames.toArray(new String[0]);
        Schema schema = this.getSchema();
        return SplitQuery.parseQuery(queryString, schema, defaultFieldArray);
    }

    public SplitQuery parseQuery(String queryString, String defaultFieldName) {
        if (defaultFieldName == null || defaultFieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Default field name cannot be null or empty");
        }
        return this.parseQuery(queryString, Arrays.asList(defaultFieldName));
    }

    public SearchResult search(SplitQuery splitQuery, int limit) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("SplitSearcher has been closed or not properly initialized");
        }
        if (splitQuery == null) {
            throw new IllegalArgumentException("SplitQuery cannot be null");
        }
        try {
            return SplitSearcher.searchWithSplitQuery(this.nativePtr, splitQuery, limit);
        }
        catch (Exception e) {
            throw new RuntimeException("Search failed: " + e.getMessage(), e);
        }
    }

    public SearchResult search(SplitQuery splitQuery, int limit, String aggregationName, SplitAggregation aggregation) {
        Map<String, SplitAggregation> aggregations = Map.of(aggregationName, aggregation);
        return this.search(splitQuery, limit, aggregations);
    }

    public SearchResult search(SplitQuery splitQuery, int limit, Map<String, SplitAggregation> aggregations) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("SplitSearcher has been closed or not properly initialized");
        }
        if (splitQuery == null) {
            throw new IllegalArgumentException("SplitQuery cannot be null");
        }
        if (aggregations == null) {
            aggregations = Map.of();
        }
        try {
            return SplitSearcher.searchWithAggregations(this.nativePtr, splitQuery, limit, aggregations);
        }
        catch (Exception e) {
            throw new RuntimeException("Search with aggregations failed: " + e.getMessage(), e);
        }
    }

    public SearchResult aggregate(SplitQuery splitQuery, String aggregationName, SplitAggregation aggregation) {
        Map<String, SplitAggregation> aggregations = Map.of(aggregationName, aggregation);
        return this.search(splitQuery, 0, aggregations);
    }

    public SearchResult aggregate(SplitQuery splitQuery, Map<String, SplitAggregation> aggregations) {
        return this.search(splitQuery, 0, aggregations);
    }

    public Document doc(DocAddress docAddress) {
        return SplitSearcher.docNative(this.nativePtr, docAddress.getSegmentOrd(), docAddress.getDoc());
    }

    public List<Document> docBatch(List<DocAddress> docAddresses) {
        if (docAddresses == null || docAddresses.isEmpty()) {
            return new ArrayList<Document>();
        }
        int[] segments = new int[docAddresses.size()];
        int[] docIds = new int[docAddresses.size()];
        for (int i = 0; i < docAddresses.size(); ++i) {
            DocAddress addr = docAddresses.get(i);
            segments[i] = addr.getSegmentOrd();
            docIds[i] = addr.getDoc();
        }
        Document[] docs = SplitSearcher.docBatchNative(this.nativePtr, segments, docIds);
        return Arrays.asList(docs);
    }

    public ByteBuffer docsBulk(List<DocAddress> docAddresses) {
        if (docAddresses == null || docAddresses.isEmpty()) {
            return null;
        }
        int[] segments = new int[docAddresses.size()];
        int[] docIds = new int[docAddresses.size()];
        for (int i = 0; i < docAddresses.size(); ++i) {
            DocAddress addr = docAddresses.get(i);
            segments[i] = addr.getSegmentOrd();
            docIds[i] = addr.getDoc();
        }
        byte[] result = SplitSearcher.docsBulkNative(this.nativePtr, segments, docIds);
        return result != null ? ByteBuffer.wrap(result) : null;
    }

    public List<Document> parseBulkDocs(ByteBuffer buffer) {
        if (buffer == null) {
            return new ArrayList<Document>();
        }
        return SplitSearcher.parseBulkDocsNative(buffer);
    }

    public CompletableFuture<Void> preloadComponents(IndexComponent ... components) {
        return CompletableFuture.runAsync(() -> SplitSearcher.preloadComponentsNative(this.nativePtr, components));
    }

    public CompletableFuture<Void> warmupQuery(Query query) {
        return CompletableFuture.runAsync(() -> SplitSearcher.warmupQueryNative(this.nativePtr, query.getNativePtr()));
    }

    public CompletableFuture<WarmupStats> warmupQueryAdvanced(Query query, IndexComponent[] components, boolean enableParallel) {
        return CompletableFuture.supplyAsync(() -> SplitSearcher.warmupQueryAdvancedNative(this.nativePtr, query.getNativePtr(), components, enableParallel));
    }

    public CacheStats getCacheStats() {
        return SplitSearcher.getCacheStatsNative(this.nativePtr);
    }

    public LoadingStats getLoadingStats() {
        return SplitSearcher.getLoadingStatsNative(this.nativePtr);
    }

    public Map<IndexComponent, Boolean> getComponentCacheStatus() {
        return SplitSearcher.getComponentCacheStatusNative(this.nativePtr);
    }

    public void evictComponents(IndexComponent ... components) {
        SplitSearcher.evictComponentsNative(this.nativePtr, components);
    }

    public List<String> listSplitFiles() {
        return SplitSearcher.listSplitFilesNative(this.nativePtr);
    }

    public boolean validateSplit() {
        return SplitSearcher.validateSplitNative(this.nativePtr);
    }

    public SplitMetadata getSplitMetadata() {
        return SplitSearcher.getSplitMetadataNative(this.nativePtr);
    }

    public List<String> tokenize(String fieldName, String text) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("SplitSearcher has been closed or not properly initialized");
        }
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        if (text == null) {
            throw new IllegalArgumentException("Text to tokenize cannot be null");
        }
        try {
            return SplitSearcher.tokenizeNative(this.nativePtr, fieldName, text);
        }
        catch (Exception e) {
            throw new RuntimeException("Tokenization failed for field '" + fieldName + "': " + e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        if (this.nativePtr != 0L) {
            SplitSearcher.closeNative(this.nativePtr);
            this.nativePtr = 0L;
        }
        this.cacheManager.removeSplitSearcher(this.splitPath);
    }

    private static native long createNativeWithSharedCache(String var0, long var1, Map<String, Object> var3);

    private static native long getSchemaFromNative(long var0);

    private static native SearchResult searchWithQueryAst(long var0, String var2, int var3);

    private static native SearchResult searchWithSplitQuery(long var0, SplitQuery var2, int var3);

    private static native SearchResult searchWithAggregations(long var0, SplitQuery var2, int var3, Map<String, SplitAggregation> var4);

    private static native Document docNative(long var0, int var2, int var3);

    private static native Document[] docBatchNative(long var0, int[] var2, int[] var3);

    private static native byte[] docsBulkNative(long var0, int[] var2, int[] var3);

    private static native List<Document> parseBulkDocsNative(ByteBuffer var0);

    private static native void preloadComponentsNative(long var0, IndexComponent[] var2);

    private static native void warmupQueryNative(long var0, long var2);

    private static native WarmupStats warmupQueryAdvancedNative(long var0, long var2, IndexComponent[] var4, boolean var5);

    private static native CacheStats getCacheStatsNative(long var0);

    private static native LoadingStats getLoadingStatsNative(long var0);

    private static native Map<IndexComponent, Boolean> getComponentCacheStatusNative(long var0);

    private static native void evictComponentsNative(long var0, IndexComponent[] var2);

    private static native List<String> listSplitFilesNative(long var0);

    private static native boolean validateSplitNative(long var0);

    private static native SplitMetadata getSplitMetadataNative(long var0);

    private static native List<String> tokenizeNative(long var0, String var2, String var3);

    private static native void closeNative(long var0);

    static {
        Tantivy.initialize();
    }

    public static class SplitMetadata {
        private final String splitId;
        private final long totalSize;
        private final long hotCacheSize;
        private final int numComponents;
        private final Map<String, Long> componentSizes;

        public SplitMetadata(String splitId, long totalSize, long hotCacheSize, int numComponents, Map<String, Long> componentSizes) {
            this.splitId = splitId;
            this.totalSize = totalSize;
            this.hotCacheSize = hotCacheSize;
            this.numComponents = numComponents;
            this.componentSizes = new HashMap<String, Long>(componentSizes);
        }

        public String getSplitId() {
            return this.splitId;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getHotCacheSize() {
            return this.hotCacheSize;
        }

        public int getNumComponents() {
            return this.numComponents;
        }

        public Map<String, Long> getComponentSizes() {
            return this.componentSizes;
        }

        public double getHotCacheRatio() {
            return (double)this.hotCacheSize / (double)this.totalSize;
        }
    }

    public static class WarmupStats {
        private final long totalBytesLoaded;
        private final long warmupTimeMs;
        private final int componentsLoaded;
        private final Map<IndexComponent, Long> componentSizes;
        private final boolean usedParallelLoading;

        public WarmupStats(long totalBytesLoaded, long warmupTimeMs, int componentsLoaded, Map<IndexComponent, Long> componentSizes, boolean usedParallelLoading) {
            this.totalBytesLoaded = totalBytesLoaded;
            this.warmupTimeMs = warmupTimeMs;
            this.componentsLoaded = componentsLoaded;
            this.componentSizes = new HashMap<IndexComponent, Long>(componentSizes);
            this.usedParallelLoading = usedParallelLoading;
        }

        public long getTotalBytesLoaded() {
            return this.totalBytesLoaded;
        }

        public long getWarmupTimeMs() {
            return this.warmupTimeMs;
        }

        public int getComponentsLoaded() {
            return this.componentsLoaded;
        }

        public Map<IndexComponent, Long> getComponentSizes() {
            return this.componentSizes;
        }

        public boolean isUsedParallelLoading() {
            return this.usedParallelLoading;
        }

        public double getLoadingSpeedMBps() {
            return this.warmupTimeMs > 0L ? (double)this.totalBytesLoaded / 1024.0 / 1024.0 / ((double)this.warmupTimeMs / 1000.0) : 0.0;
        }
    }

    public static class ComponentStats {
        private final long bytesLoaded;
        private final long loadTime;
        private final int loadCount;
        private final boolean isPreloaded;

        public ComponentStats(long bytesLoaded, long loadTime, int loadCount, boolean isPreloaded) {
            this.bytesLoaded = bytesLoaded;
            this.loadTime = loadTime;
            this.loadCount = loadCount;
            this.isPreloaded = isPreloaded;
        }

        public long getBytesLoaded() {
            return this.bytesLoaded;
        }

        public long getLoadTime() {
            return this.loadTime;
        }

        public int getLoadCount() {
            return this.loadCount;
        }

        public boolean isPreloaded() {
            return this.isPreloaded;
        }

        public double getAverageLoadTime() {
            return this.loadCount > 0 ? (double)this.loadTime / (double)this.loadCount : 0.0;
        }
    }

    public static class LoadingStats {
        private final long totalBytesLoaded;
        private final long totalLoadTime;
        private final int activeConcurrentLoads;
        private final Map<IndexComponent, ComponentStats> componentStats;

        public LoadingStats(long totalBytesLoaded, long totalLoadTime, int activeConcurrentLoads, Map<IndexComponent, ComponentStats> componentStats) {
            this.totalBytesLoaded = totalBytesLoaded;
            this.totalLoadTime = totalLoadTime;
            this.activeConcurrentLoads = activeConcurrentLoads;
            this.componentStats = new HashMap<IndexComponent, ComponentStats>(componentStats);
        }

        public long getTotalBytesLoaded() {
            return this.totalBytesLoaded;
        }

        public long getTotalLoadTime() {
            return this.totalLoadTime;
        }

        public int getActiveConcurrentLoads() {
            return this.activeConcurrentLoads;
        }

        public Map<IndexComponent, ComponentStats> getComponentStats() {
            return this.componentStats;
        }

        public double getAverageLoadSpeed() {
            return this.totalLoadTime > 0L ? (double)this.totalBytesLoaded / (double)this.totalLoadTime * 1000.0 : 0.0;
        }
    }

    public static class CacheStats {
        private final long hitCount;
        private final long missCount;
        private final long evictionCount;
        private final long totalSize;
        private final long maxSize;

        public CacheStats(long hitCount, long missCount, long evictionCount, long totalSize, long maxSize) {
            this.hitCount = hitCount;
            this.missCount = missCount;
            this.evictionCount = evictionCount;
            this.totalSize = totalSize;
            this.maxSize = maxSize;
        }

        public double getHitRate() {
            long total = this.hitCount + this.missCount;
            return total > 0L ? (double)this.hitCount / (double)total : 0.0;
        }

        public long getHitCount() {
            return this.hitCount;
        }

        public long getMissCount() {
            return this.missCount;
        }

        public long getEvictionCount() {
            return this.evictionCount;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getMaxSize() {
            return this.maxSize;
        }

        public long getTotalRequests() {
            return this.hitCount + this.missCount;
        }

        public double getUtilization() {
            return (double)this.totalSize / (double)this.maxSize;
        }
    }

    public static enum IndexComponent {
        SCHEMA,
        STORE,
        FASTFIELD,
        POSTINGS,
        POSITIONS,
        FIELDNORM;

    }
}

