/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.split;

import io.indextables.tantivy4java.split.SplitQuery;

public class SplitRangeQuery
extends SplitQuery {
    private final String field;
    private final RangeBound lowerBound;
    private final RangeBound upperBound;
    private final String fieldType;

    public SplitRangeQuery(String field, RangeBound lowerBound, RangeBound upperBound, String fieldType) {
        if (field == null) {
            throw new IllegalArgumentException("Field cannot be null");
        }
        if (lowerBound == null || upperBound == null) {
            throw new IllegalArgumentException("Range bounds cannot be null");
        }
        this.field = field;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.fieldType = fieldType != null ? fieldType : "str";
    }

    public SplitRangeQuery(String field, RangeBound lowerBound, RangeBound upperBound) {
        this(field, lowerBound, upperBound, "str");
    }

    public static SplitRangeQuery inclusiveRange(String field, String lower, String upper, String fieldType) {
        return new SplitRangeQuery(field, lower != null ? RangeBound.inclusive(lower) : RangeBound.unbounded(), upper != null ? RangeBound.inclusive(upper) : RangeBound.unbounded(), fieldType);
    }

    public static SplitRangeQuery exclusiveRange(String field, String lower, String upper, String fieldType) {
        return new SplitRangeQuery(field, lower != null ? RangeBound.exclusive(lower) : RangeBound.unbounded(), upper != null ? RangeBound.exclusive(upper) : RangeBound.unbounded(), fieldType);
    }

    public String getField() {
        return this.field;
    }

    public RangeBound getLowerBound() {
        return this.lowerBound;
    }

    public RangeBound getUpperBound() {
        return this.upperBound;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    @Override
    public native String toQueryAstJson();

    public String toString() {
        StringBuilder sb = new StringBuilder("SplitRangeQuery(");
        sb.append("field=").append(this.field);
        sb.append(", range=");
        if (this.lowerBound.isUnbounded()) {
            sb.append("*");
        } else {
            sb.append(this.lowerBound.getType() == RangeBound.BoundType.INCLUSIVE ? "[" : "(");
            sb.append(this.lowerBound.getValue());
        }
        sb.append(" TO ");
        if (this.upperBound.isUnbounded()) {
            sb.append("*");
        } else {
            sb.append(this.upperBound.getValue());
            sb.append(this.upperBound.getType() == RangeBound.BoundType.INCLUSIVE ? "]" : ")");
        }
        sb.append(", type=").append(this.fieldType);
        sb.append(")");
        return sb.toString();
    }

    public static class RangeBound {
        private final String value;
        private final BoundType type;

        private RangeBound(String value, BoundType type) {
            this.value = value;
            this.type = type;
        }

        public static RangeBound inclusive(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Value cannot be null for inclusive bound");
            }
            return new RangeBound(value, BoundType.INCLUSIVE);
        }

        public static RangeBound exclusive(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Value cannot be null for exclusive bound");
            }
            return new RangeBound(value, BoundType.EXCLUSIVE);
        }

        public static RangeBound unbounded() {
            return new RangeBound(null, BoundType.UNBOUNDED);
        }

        public String getValue() {
            return this.value;
        }

        public BoundType getType() {
            return this.type;
        }

        public boolean isUnbounded() {
            return this.type == BoundType.UNBOUNDED;
        }

        public String toString() {
            switch (this.type) {
                case INCLUSIVE: {
                    return "[" + this.value;
                }
                case EXCLUSIVE: {
                    return "(" + this.value;
                }
                case UNBOUNDED: {
                    return "*";
                }
            }
            return "unknown";
        }

        public static enum BoundType {
            INCLUSIVE,
            EXCLUSIVE,
            UNBOUNDED;

        }
    }
}

