/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.split;

import io.indextables.tantivy4java.split.SplitQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SplitPhraseQuery
extends SplitQuery {
    private final String field;
    private final List<String> terms;
    private final int slop;

    public SplitPhraseQuery(String field, List<String> terms) {
        this(field, terms, 0);
    }

    public SplitPhraseQuery(String field, List<String> terms, int slop) {
        if (field == null || field.trim().isEmpty()) {
            throw new IllegalArgumentException("Field cannot be null or empty");
        }
        if (terms == null || terms.isEmpty()) {
            throw new IllegalArgumentException("Terms cannot be null or empty");
        }
        if (slop < 0) {
            throw new IllegalArgumentException("Slop cannot be negative");
        }
        this.field = field.trim();
        this.terms = new ArrayList<String>();
        for (String term : terms) {
            if (term == null || term.trim().isEmpty()) {
                throw new IllegalArgumentException("Individual terms cannot be null or empty");
            }
            this.terms.add(term.trim());
        }
        this.slop = slop;
    }

    public SplitPhraseQuery(String field, String ... terms) {
        this(field, Arrays.asList(terms), 0);
    }

    public SplitPhraseQuery(String field, int slop, String ... terms) {
        this(field, Arrays.asList(terms), slop);
    }

    public String getField() {
        return this.field;
    }

    public List<String> getTerms() {
        return new ArrayList<String>(this.terms);
    }

    public int getSlop() {
        return this.slop;
    }

    public boolean isExactPhrase() {
        return this.slop == 0;
    }

    public int getTermCount() {
        return this.terms.size();
    }

    public static SplitPhraseQuery exactPhrase(String field, List<String> terms) {
        return new SplitPhraseQuery(field, terms, 0);
    }

    public static SplitPhraseQuery exactPhrase(String field, String ... terms) {
        return new SplitPhraseQuery(field, Arrays.asList(terms), 0);
    }

    public static SplitPhraseQuery sloppyPhrase(String field, int slop, List<String> terms) {
        return new SplitPhraseQuery(field, terms, slop);
    }

    public static SplitPhraseQuery sloppyPhrase(String field, int slop, String ... terms) {
        return new SplitPhraseQuery(field, Arrays.asList(terms), slop);
    }

    @Override
    public native String toQueryAstJson();

    public String toString() {
        StringBuilder sb = new StringBuilder("SplitPhraseQuery(");
        sb.append("field=").append(this.field);
        sb.append(", terms=[");
        for (int i = 0; i < this.terms.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"").append(this.terms.get(i)).append("\"");
        }
        sb.append("]");
        if (this.slop > 0) {
            sb.append(", slop=").append(this.slop);
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SplitPhraseQuery that = (SplitPhraseQuery)obj;
        return this.slop == that.slop && this.field.equals(that.field) && this.terms.equals(that.terms);
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.terms.hashCode();
        result = 31 * result + this.slop;
        return result;
    }
}

