/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.split;

import io.indextables.tantivy4java.config.FileSystemConfig;
import io.indextables.tantivy4java.core.Tantivy;
import io.indextables.tantivy4java.query.Query;
import io.indextables.tantivy4java.result.SearchResult;
import io.indextables.tantivy4java.split.SplitSearcher;
import io.indextables.tantivy4java.split.merge.QuickwitSplit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SplitCacheManager
implements AutoCloseable {
    private static final Map<String, SplitCacheManager> instances = new ConcurrentHashMap<String, SplitCacheManager>();
    private static final ReentrantReadWriteLock instancesLock = new ReentrantReadWriteLock();
    private static final AtomicReference<SplitCacheManager> GLOBAL_INSTANCE = new AtomicReference();
    private final String cacheName;
    private final String cacheKey;
    private final long maxCacheSize;
    private final Map<String, SplitSearcher> managedSearchers;
    private final AtomicLong totalCacheSize;
    private final long nativePtr;
    private final Map<String, String> awsConfig;

    private SplitCacheManager(CacheConfig config) {
        this.cacheName = config.getCacheName();
        this.cacheKey = config.getCacheKey();
        this.maxCacheSize = config.getMaxCacheSize();
        this.managedSearchers = new ConcurrentHashMap<String, SplitSearcher>();
        this.totalCacheSize = new AtomicLong(0L);
        this.awsConfig = new HashMap<String, String>(config.getAwsConfig());
        this.nativePtr = SplitCacheManager.createNativeCacheManager(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplitCacheManager getInstance(CacheConfig config) {
        SplitCacheManager existing;
        String cacheKey = config.getCacheKey();
        instancesLock.readLock().lock();
        try {
            existing = instances.get(cacheKey);
            if (existing != null) {
                System.out.println("\ud83d\udd27 CACHE REUSE: Using existing cache instance: " + config.getCacheName());
                SplitCacheManager splitCacheManager = existing;
                return splitCacheManager;
            }
        }
        finally {
            instancesLock.readLock().unlock();
        }
        instancesLock.writeLock().lock();
        try {
            existing = instances.get(cacheKey);
            if (existing != null) {
                System.out.println("\ud83d\udd27 CACHE REUSE: Cache created by another thread: " + config.getCacheName());
                SplitCacheManager splitCacheManager = existing;
                return splitCacheManager;
            }
            System.out.println("\ud83d\udd27 CACHE CREATE: Creating NEW cache instance: " + config.getCacheName());
            SplitCacheManager.validateCacheConfig(config);
            SplitCacheManager newInstance = new SplitCacheManager(config);
            instances.put(cacheKey, newInstance);
            GLOBAL_INSTANCE.compareAndSet(null, newInstance);
            SplitCacheManager splitCacheManager = newInstance;
            return splitCacheManager;
        }
        finally {
            instancesLock.writeLock().unlock();
        }
    }

    public static SplitCacheManager getGlobalInstance() {
        SplitCacheManager existing = GLOBAL_INSTANCE.get();
        if (existing != null) {
            return existing;
        }
        CacheConfig defaultConfig = new CacheConfig("global-default").withMaxCacheSize(500000000L);
        return SplitCacheManager.getInstance(defaultConfig);
    }

    public static Map<String, SplitCacheManager> getAllInstances() {
        return new HashMap<String, SplitCacheManager>(instances);
    }

    private static void validateCacheConfig(CacheConfig config) {
        if (config.getCacheName() == null || config.getCacheName().trim().isEmpty()) {
            throw new IllegalArgumentException("Cache name cannot be null or empty");
        }
        if (config.getMaxCacheSize() <= 0L) {
            throw new IllegalArgumentException("Max cache size must be positive, got: " + config.getMaxCacheSize());
        }
        if (config.getMaxConcurrentLoads() <= 0) {
            throw new IllegalArgumentException("Max concurrent loads must be positive, got: " + config.getMaxConcurrentLoads());
        }
    }

    public SplitSearcher createSplitSearcher(String splitPath, QuickwitSplit.SplitMetadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("Split metadata is required for SplitSearcher creation. Use QuickwitSplit.convertIndexFromPath() to generate metadata, store it in your metastore, then pass it here for optimized loading.");
        }
        if (!metadata.hasFooterOffsets()) {
            throw new IllegalArgumentException("Split metadata must contain footer offsets for optimized loading. Ensure the metadata was generated by QuickwitSplit.convertIndexFromPath() and has hasFooterOffsets() == true.");
        }
        this.validateSplitOffsets(splitPath, metadata);
        HashMap<String, Object> splitConfig = new HashMap<String, Object>();
        if (!this.awsConfig.isEmpty()) {
            splitConfig.put("aws_config", this.awsConfig);
        }
        splitConfig.put("footer_start_offset", metadata.getFooterStartOffset());
        splitConfig.put("footer_end_offset", metadata.getFooterEndOffset());
        if (metadata.getDocMappingUid() != null && !metadata.getDocMappingUid().trim().isEmpty()) {
            splitConfig.put("doc_mapping_uid", metadata.getDocMappingUid());
        }
        if (metadata.getDocMappingJson() != null && !metadata.getDocMappingJson().trim().isEmpty()) {
            splitConfig.put("doc_mapping", metadata.getDocMappingJson());
        }
        splitConfig.put("split_metadata", metadata);
        String resolvedSplitPath = splitPath;
        if (!splitPath.contains("://")) {
            resolvedSplitPath = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(splitPath) : splitPath;
        }
        SplitSearcher searcher = new SplitSearcher(resolvedSplitPath, this, splitConfig);
        this.managedSearchers.put(resolvedSplitPath, searcher);
        return searcher;
    }

    @Deprecated
    private SplitSearcher createSplitSearcher(String splitPath, Map<String, Object> splitConfig) {
        SplitSearcher searcher = new SplitSearcher(splitPath, this, splitConfig);
        this.managedSearchers.put(splitPath, searcher);
        return searcher;
    }

    public List<SplitSearcher> createMultipleSplitSearchers(Map<String, QuickwitSplit.SplitMetadata> splitPathsWithMetadata) {
        ArrayList<SplitSearcher> searchers = new ArrayList<SplitSearcher>();
        for (Map.Entry<String, QuickwitSplit.SplitMetadata> entry : splitPathsWithMetadata.entrySet()) {
            searchers.add(this.createSplitSearcher(entry.getKey(), entry.getValue()));
        }
        return searchers;
    }

    public SearchResult searchAcrossAllSplits(Query query, int totalLimit) {
        return SplitCacheManager.searchAcrossAllSplitsNative(this.nativePtr, query.getNativePtr(), totalLimit);
    }

    public SearchResult searchAcrossSplits(List<String> splitPaths, Query query, int totalLimit) {
        return SplitCacheManager.searchAcrossSplitsNative(this.nativePtr, splitPaths, query.getNativePtr(), totalLimit);
    }

    void removeSplitSearcher(String splitPath) {
        this.managedSearchers.remove(splitPath);
    }

    public Set<String> getManagedSplitPaths() {
        return new HashSet<String>(this.managedSearchers.keySet());
    }

    public GlobalCacheStats getGlobalCacheStats() {
        GlobalCacheStats nativeStats = SplitCacheManager.getGlobalCacheStatsNative(this.nativePtr);
        return new GlobalCacheStats(nativeStats.getTotalHits(), nativeStats.getTotalMisses(), nativeStats.getTotalEvictions(), nativeStats.getCurrentSize(), nativeStats.getMaxSize(), this.managedSearchers.size());
    }

    public ComprehensiveCacheStats getComprehensiveCacheStats() {
        long[][] perCacheMetrics = SplitCacheManager.getComprehensiveCacheStatsNative(this.nativePtr);
        if (perCacheMetrics == null || perCacheMetrics.length != 4) {
            GlobalCacheStats basicStats = this.getGlobalCacheStats();
            CacheTypeStats fallback = new CacheTypeStats("fallback", basicStats.getTotalHits(), basicStats.getTotalMisses(), basicStats.getTotalEvictions(), basicStats.getCurrentSize());
            return new ComprehensiveCacheStats(fallback, fallback, fallback, fallback);
        }
        CacheTypeStats byteRangeCache = new CacheTypeStats("ByteRangeCache", perCacheMetrics[0][0], perCacheMetrics[0][1], perCacheMetrics[0][2], perCacheMetrics[0][3]);
        CacheTypeStats footerCache = new CacheTypeStats("FooterCache", perCacheMetrics[1][0], perCacheMetrics[1][1], perCacheMetrics[1][2], perCacheMetrics[1][3]);
        CacheTypeStats fastFieldCache = new CacheTypeStats("FastFieldCache", perCacheMetrics[2][0], perCacheMetrics[2][1], perCacheMetrics[2][2], perCacheMetrics[2][3]);
        CacheTypeStats splitCache = new CacheTypeStats("SplitCache", perCacheMetrics[3][0], perCacheMetrics[3][1], perCacheMetrics[3][2], perCacheMetrics[3][3]);
        return new ComprehensiveCacheStats(byteRangeCache, footerCache, fastFieldCache, splitCache);
    }

    public void preloadComponents(String splitPath, Set<SplitSearcher.IndexComponent> components) {
        SplitCacheManager.preloadComponentsNative(this.nativePtr, splitPath, components);
    }

    public void evictComponents(String splitPath, Set<SplitSearcher.IndexComponent> components) {
        SplitCacheManager.evictComponentsNative(this.nativePtr, splitPath, components);
    }

    public void forceEviction(long targetSizeBytes) {
        SplitCacheManager.forceEvictionNative(this.nativePtr, targetSizeBytes);
    }

    public CacheFlushStats flushAllCaches() {
        GlobalCacheStats beforeStats = this.getGlobalCacheStats();
        SplitCacheManager.forceEvictionNative(this.nativePtr, 0L);
        EnumSet<SplitSearcher.IndexComponent> allComponents = EnumSet.allOf(SplitSearcher.IndexComponent.class);
        for (String splitPath : this.managedSearchers.keySet()) {
            this.evictComponents(splitPath, allComponents);
        }
        GlobalCacheStats afterStats = this.getGlobalCacheStats();
        return new CacheFlushStats(beforeStats, afterStats, this.managedSearchers.size());
    }

    public boolean flushSplitCaches(String splitPath) {
        if (!this.managedSearchers.containsKey(splitPath)) {
            return false;
        }
        EnumSet<SplitSearcher.IndexComponent> allComponents = EnumSet.allOf(SplitSearcher.IndexComponent.class);
        this.evictComponents(splitPath, allComponents);
        return true;
    }

    public void flushCacheTypes(Set<CacheType> cacheTypes) {
        if (cacheTypes.contains((Object)CacheType.LEAF_SEARCH) || cacheTypes.contains((Object)CacheType.BYTE_RANGE)) {
            SplitCacheManager.forceEvictionNative(this.nativePtr, this.getGlobalCacheStats().getCurrentSize() / 2L);
        }
        if (cacheTypes.contains((Object)CacheType.COMPONENT)) {
            EnumSet<SplitSearcher.IndexComponent> allComponents = EnumSet.allOf(SplitSearcher.IndexComponent.class);
            for (String splitPath : this.managedSearchers.keySet()) {
                this.evictComponents(splitPath, allComponents);
            }
        }
    }

    @Override
    public void close() {
        for (SplitSearcher searcher : this.managedSearchers.values()) {
            try {
                searcher.close();
            }
            catch (Exception exception) {}
        }
        this.managedSearchers.clear();
        if (this.nativePtr != 0L) {
            SplitCacheManager.closeNativeCacheManager(this.nativePtr);
        }
        instances.remove(this.cacheKey);
    }

    private void validateSplitOffsets(String splitPath, QuickwitSplit.SplitMetadata metadata) {
        long footerStart = metadata.getFooterStartOffset();
        long footerEnd = metadata.getFooterEndOffset();
        if (footerEnd <= 0L) {
            throw new IllegalArgumentException(String.format("Invalid split metadata for '%s': footer_end_offset must be > 0, got %d. Split metadata: splitId='%s', numDocs=%d, footerOffsets=%d-%d", splitPath, footerEnd, metadata.getSplitId(), metadata.getNumDocs(), footerStart, footerEnd));
        }
        if (footerEnd <= footerStart) {
            throw new IllegalArgumentException(String.format("Invalid split metadata for '%s': footer_end_offset (%d) must be > footer_start_offset (%d). Split metadata: splitId='%s', numDocs=%d, footerOffsets=%d-%d", splitPath, footerEnd, footerStart, metadata.getSplitId(), metadata.getNumDocs(), footerStart, footerEnd));
        }
        if (footerStart < 0L) {
            throw new IllegalArgumentException(String.format("Invalid split metadata for '%s': footer_start_offset cannot be negative, got %d. Split metadata: splitId='%s', numDocs=%d, footerOffsets=%d-%d", splitPath, footerStart, metadata.getSplitId(), metadata.getNumDocs(), footerStart, footerEnd));
        }
        long MAX_REASONABLE_SIZE = 0x1900000000L;
        if (footerEnd > 0x1900000000L) {
            throw new IllegalArgumentException(String.format("Invalid split metadata for '%s': footer_end_offset (%d) is unreasonably large (> 100GB), likely corrupted metadata. Split metadata: splitId='%s', numDocs=%d, footerOffsets=%d-%d", splitPath, footerEnd, metadata.getSplitId(), metadata.getNumDocs(), footerStart, footerEnd));
        }
        if (footerStart > 0x1900000000L) {
            throw new IllegalArgumentException(String.format("Invalid split metadata for '%s': footer_start_offset (%d) is unreasonably large (> 100GB), likely corrupted metadata. Split metadata: splitId='%s', numDocs=%d, footerOffsets=%d-%d", splitPath, footerStart, metadata.getSplitId(), metadata.getNumDocs(), footerStart, footerEnd));
        }
        System.out.printf("\u2705 Split metadata validation passed for '%s': footerOffsets=%d-%d%n", splitPath, footerStart, footerEnd);
    }

    private static native long createNativeCacheManager(CacheConfig var0);

    private static native void closeNativeCacheManager(long var0);

    private static native GlobalCacheStats getGlobalCacheStatsNative(long var0);

    private static native long[][] getComprehensiveCacheStatsNative(long var0);

    private static native void preloadComponentsNative(long var0, String var2, Set<SplitSearcher.IndexComponent> var3);

    private static native void evictComponentsNative(long var0, String var2, Set<SplitSearcher.IndexComponent> var3);

    private static native void forceEvictionNative(long var0, long var2);

    private static native SearchResult searchAcrossAllSplitsNative(long var0, long var2, int var4);

    private static native SearchResult searchAcrossSplitsNative(long var0, List<String> var2, long var3, int var5);

    public String getCacheName() {
        return this.cacheName;
    }

    String getCacheKey() {
        return this.cacheKey;
    }

    long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    long getNativePtr() {
        return this.nativePtr;
    }

    static {
        Tantivy.initialize();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("\ud83d\udd27 CACHE CLEANUP: Shutting down all SplitCacheManager instances...");
            Map<String, SplitCacheManager> map = instances;
            synchronized (map) {
                for (SplitCacheManager manager : instances.values()) {
                    try {
                        manager.close();
                    }
                    catch (Exception e) {
                        System.err.println("Warning: Failed to close cache manager: " + e.getMessage());
                    }
                }
                instances.clear();
            }
            System.out.println("\ud83d\udd27 CACHE CLEANUP: All cache instances cleaned up successfully");
        }, "SplitCacheManager-Shutdown"));
    }

    public static enum CacheType {
        LEAF_SEARCH,
        BYTE_RANGE,
        COMPONENT;

    }

    public static class CacheFlushStats {
        private final long bytesFreedTotal;
        private final long itemsEvicted;
        private final int splitsAffected;
        private final GlobalCacheStats beforeStats;
        private final GlobalCacheStats afterStats;

        public CacheFlushStats(GlobalCacheStats beforeStats, GlobalCacheStats afterStats, int splitsAffected) {
            this.beforeStats = beforeStats;
            this.afterStats = afterStats;
            this.splitsAffected = splitsAffected;
            this.bytesFreedTotal = beforeStats.getCurrentSize() - afterStats.getCurrentSize();
            this.itemsEvicted = beforeStats.getTotalHits() + beforeStats.getTotalMisses() - (afterStats.getTotalHits() + afterStats.getTotalMisses());
        }

        public long getBytesFreed() {
            return this.bytesFreedTotal;
        }

        public long getItemsEvicted() {
            return this.itemsEvicted;
        }

        public int getSplitsAffected() {
            return this.splitsAffected;
        }

        public GlobalCacheStats getBeforeStats() {
            return this.beforeStats;
        }

        public GlobalCacheStats getAfterStats() {
            return this.afterStats;
        }

        public String toString() {
            return String.format("CacheFlushStats{bytesFreed=%d, itemsEvicted=%d, splitsAffected=%d, beforeSize=%d, afterSize=%d}", this.bytesFreedTotal, this.itemsEvicted, this.splitsAffected, this.beforeStats.getCurrentSize(), this.afterStats.getCurrentSize());
        }
    }

    public static class CacheTypeStats {
        private final String cacheType;
        private final long hits;
        private final long misses;
        private final long evictions;
        private final long sizeBytes;

        public CacheTypeStats(String cacheType, long hits, long misses, long evictions, long sizeBytes) {
            this.cacheType = cacheType;
            this.hits = hits;
            this.misses = misses;
            this.evictions = evictions;
            this.sizeBytes = sizeBytes;
        }

        public String getCacheType() {
            return this.cacheType;
        }

        public long getHits() {
            return this.hits;
        }

        public long getMisses() {
            return this.misses;
        }

        public long getEvictions() {
            return this.evictions;
        }

        public long getSizeBytes() {
            return this.sizeBytes;
        }

        public double getHitRate() {
            long total = this.hits + this.misses;
            return total > 0L ? (double)this.hits / (double)total : 0.0;
        }

        public String toString() {
            return String.format("%s{hits=%d, misses=%d, evictions=%d, hitRate=%.2f%%, sizeBytes=%d}", this.cacheType, this.hits, this.misses, this.evictions, this.getHitRate() * 100.0, this.sizeBytes);
        }
    }

    public static class ComprehensiveCacheStats {
        private final CacheTypeStats byteRangeCache;
        private final CacheTypeStats footerCache;
        private final CacheTypeStats fastFieldCache;
        private final CacheTypeStats splitCache;
        private final GlobalCacheStats aggregated;

        public ComprehensiveCacheStats(CacheTypeStats byteRangeCache, CacheTypeStats footerCache, CacheTypeStats fastFieldCache, CacheTypeStats splitCache) {
            this.byteRangeCache = byteRangeCache;
            this.footerCache = footerCache;
            this.fastFieldCache = fastFieldCache;
            this.splitCache = splitCache;
            long totalHits = byteRangeCache.hits + footerCache.hits + fastFieldCache.hits + splitCache.hits;
            long totalMisses = byteRangeCache.misses + footerCache.misses + fastFieldCache.misses + splitCache.misses;
            long totalEvictions = byteRangeCache.evictions + footerCache.evictions + fastFieldCache.evictions + splitCache.evictions;
            long totalSize = byteRangeCache.sizeBytes + footerCache.sizeBytes + fastFieldCache.sizeBytes + splitCache.sizeBytes;
            this.aggregated = new GlobalCacheStats(totalHits, totalMisses, totalEvictions, totalSize, 0L, 0);
        }

        public CacheTypeStats getByteRangeCache() {
            return this.byteRangeCache;
        }

        public CacheTypeStats getFooterCache() {
            return this.footerCache;
        }

        public CacheTypeStats getFastFieldCache() {
            return this.fastFieldCache;
        }

        public CacheTypeStats getSplitCache() {
            return this.splitCache;
        }

        public GlobalCacheStats getAggregated() {
            return this.aggregated;
        }

        public String toString() {
            return String.format("ComprehensiveCacheStats{\n  \ud83d\udce6 ByteRangeCache: %s\n  \ud83d\udcc4 FooterCache: %s\n  \u26a1 FastFieldCache: %s\n  \ud83d\udd0d SplitCache: %s\n  \ud83c\udfc6 Aggregated: %s\n}", this.byteRangeCache, this.footerCache, this.fastFieldCache, this.splitCache, this.aggregated);
        }
    }

    public static class GlobalCacheStats {
        private final long totalHits;
        private final long totalMisses;
        private final long totalEvictions;
        private final long currentSize;
        private final long maxSize;
        private final int activeSplits;

        public GlobalCacheStats(long totalHits, long totalMisses, long totalEvictions, long currentSize, long maxSize, int activeSplits) {
            this.totalHits = totalHits;
            this.totalMisses = totalMisses;
            this.totalEvictions = totalEvictions;
            this.currentSize = currentSize;
            this.maxSize = maxSize;
            this.activeSplits = activeSplits;
        }

        public long getTotalHits() {
            return this.totalHits;
        }

        public long getTotalMisses() {
            return this.totalMisses;
        }

        public long getTotalEvictions() {
            return this.totalEvictions;
        }

        public long getCurrentSize() {
            return this.currentSize;
        }

        public long getMaxSize() {
            return this.maxSize;
        }

        public int getActiveSplits() {
            return this.activeSplits;
        }

        public double getHitRate() {
            long total = this.totalHits + this.totalMisses;
            return total > 0L ? (double)this.totalHits / (double)total : 0.0;
        }

        public double getUtilization() {
            return this.maxSize > 0L ? (double)this.currentSize / (double)this.maxSize : 0.0;
        }

        public String toString() {
            return String.format("GlobalCacheStats{hits=%d, misses=%d, evictions=%d, hitRate=%.2f%%, currentSize=%d, maxSize=%d, utilization=%.2f%%, activeSplits=%d}", this.totalHits, this.totalMisses, this.totalEvictions, this.getHitRate() * 100.0, this.currentSize, this.maxSize, this.getUtilization() * 100.0, this.activeSplits);
        }
    }

    public static class CacheConfig {
        private final String cacheName;
        private long maxCacheSize = 200000000L;
        private int maxConcurrentLoads = 8;
        private boolean enableQueryCache = true;
        private Map<String, String> awsConfig = new HashMap<String, String>();
        private Map<String, String> azureConfig = new HashMap<String, String>();
        private Map<String, String> gcpConfig = new HashMap<String, String>();

        public CacheConfig(String cacheName) {
            this.cacheName = cacheName;
        }

        public CacheConfig withMaxCacheSize(long maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        public CacheConfig withMaxConcurrentLoads(int maxConcurrentLoads) {
            this.maxConcurrentLoads = maxConcurrentLoads;
            return this;
        }

        public CacheConfig withQueryCache(boolean enabled) {
            this.enableQueryCache = enabled;
            return this;
        }

        public CacheConfig withAwsCredentials(String accessKey, String secretKey) {
            this.awsConfig.put("access_key", accessKey);
            this.awsConfig.put("secret_key", secretKey);
            return this;
        }

        public CacheConfig withAwsCredentials(String accessKey, String secretKey, String sessionToken) {
            this.awsConfig.put("access_key", accessKey);
            this.awsConfig.put("secret_key", secretKey);
            this.awsConfig.put("session_token", sessionToken);
            return this;
        }

        public CacheConfig withAwsRegion(String region) {
            this.awsConfig.put("region", region);
            return this;
        }

        public CacheConfig withAwsEndpoint(String endpoint) {
            this.awsConfig.put("endpoint", endpoint);
            return this;
        }

        public CacheConfig withAwsPathStyleAccess(boolean pathStyleAccess) {
            this.awsConfig.put("path_style_access", String.valueOf(pathStyleAccess));
            return this;
        }

        public CacheConfig withAzureCredentials(String accountName, String accountKey) {
            this.azureConfig.put("account_name", accountName);
            this.azureConfig.put("account_key", accountKey);
            return this;
        }

        public CacheConfig withAzureConnectionString(String connectionString) {
            this.azureConfig.put("connection_string", connectionString);
            return this;
        }

        public CacheConfig withAzureEndpoint(String endpoint) {
            this.azureConfig.put("endpoint", endpoint);
            return this;
        }

        public CacheConfig withGcpCredentials(String projectId, String serviceAccountKey) {
            this.gcpConfig.put("project_id", projectId);
            this.gcpConfig.put("service_account_key", serviceAccountKey);
            return this;
        }

        public CacheConfig withGcpCredentialsFile(String credentialsFilePath) {
            this.gcpConfig.put("credentials_file", credentialsFilePath);
            return this;
        }

        public CacheConfig withGcpEndpoint(String endpoint) {
            this.gcpConfig.put("endpoint", endpoint);
            return this;
        }

        public String getCacheName() {
            return this.cacheName;
        }

        public long getMaxCacheSize() {
            return this.maxCacheSize;
        }

        public int getMaxConcurrentLoads() {
            return this.maxConcurrentLoads;
        }

        public boolean isQueryCacheEnabled() {
            return this.enableQueryCache;
        }

        public Map<String, String> getAwsConfig() {
            return this.awsConfig;
        }

        public Map<String, String> getAzureConfig() {
            return this.azureConfig;
        }

        public Map<String, String> getGcpConfig() {
            return this.gcpConfig;
        }

        public String getCacheKey() {
            StringBuilder keyBuilder = new StringBuilder();
            keyBuilder.append("name=").append(this.cacheName);
            keyBuilder.append(",maxSize=").append(this.maxCacheSize);
            keyBuilder.append(",maxLoads=").append(this.maxConcurrentLoads);
            keyBuilder.append(",queryCache=").append(this.enableQueryCache);
            if (!this.awsConfig.isEmpty()) {
                keyBuilder.append(",aws={");
                this.awsConfig.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> keyBuilder.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(","));
                keyBuilder.setLength(keyBuilder.length() - 1);
                keyBuilder.append("}");
            }
            if (!this.azureConfig.isEmpty()) {
                keyBuilder.append(",azure={");
                this.azureConfig.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> keyBuilder.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(","));
                keyBuilder.setLength(keyBuilder.length() - 1);
                keyBuilder.append("}");
            }
            if (!this.gcpConfig.isEmpty()) {
                keyBuilder.append(",gcp={");
                this.gcpConfig.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> keyBuilder.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(","));
                keyBuilder.setLength(keyBuilder.length() - 1);
                keyBuilder.append("}");
            }
            return keyBuilder.toString();
        }
    }
}

