/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.split;

import io.indextables.tantivy4java.split.SplitQuery;
import java.util.ArrayList;
import java.util.List;

public class SplitBooleanQuery
extends SplitQuery {
    private final List<SplitQuery> mustQueries = new ArrayList<SplitQuery>();
    private final List<SplitQuery> shouldQueries = new ArrayList<SplitQuery>();
    private final List<SplitQuery> mustNotQueries = new ArrayList<SplitQuery>();
    private Integer minimumShouldMatch = null;

    public SplitBooleanQuery addMust(SplitQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        this.mustQueries.add(query);
        return this;
    }

    public SplitBooleanQuery addShould(SplitQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        this.shouldQueries.add(query);
        return this;
    }

    public SplitBooleanQuery addMustNot(SplitQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        this.mustNotQueries.add(query);
        return this;
    }

    public SplitBooleanQuery setMinimumShouldMatch(int minimum) {
        this.minimumShouldMatch = minimum;
        return this;
    }

    public List<SplitQuery> getMustQueries() {
        return new ArrayList<SplitQuery>(this.mustQueries);
    }

    public List<SplitQuery> getShouldQueries() {
        return new ArrayList<SplitQuery>(this.shouldQueries);
    }

    public List<SplitQuery> getMustNotQueries() {
        return new ArrayList<SplitQuery>(this.mustNotQueries);
    }

    public Integer getMinimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public static SplitBooleanQuery intersection(List<SplitQuery> queries) {
        SplitBooleanQuery boolQuery = new SplitBooleanQuery();
        for (SplitQuery query : queries) {
            boolQuery.addMust(query);
        }
        return boolQuery;
    }

    public static SplitBooleanQuery union(List<SplitQuery> queries) {
        SplitBooleanQuery boolQuery = new SplitBooleanQuery();
        for (SplitQuery query : queries) {
            boolQuery.addShould(query);
        }
        return boolQuery;
    }

    @Override
    public native String toQueryAstJson();

    public String toString() {
        StringBuilder sb = new StringBuilder("SplitBooleanQuery(");
        if (!this.mustQueries.isEmpty()) {
            sb.append("must=").append(this.mustQueries.size()).append(" ");
        }
        if (!this.shouldQueries.isEmpty()) {
            sb.append("should=").append(this.shouldQueries.size()).append(" ");
        }
        if (!this.mustNotQueries.isEmpty()) {
            sb.append("mustNot=").append(this.mustNotQueries.size()).append(" ");
        }
        if (this.minimumShouldMatch != null) {
            sb.append("minShouldMatch=").append(this.minimumShouldMatch);
        }
        sb.append(")");
        return sb.toString();
    }
}

