/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.result;

import io.indextables.tantivy4java.aggregation.AggregationResult;
import io.indextables.tantivy4java.core.DocAddress;
import io.indextables.tantivy4java.core.Tantivy;
import java.util.List;
import java.util.Map;

public class SearchResult
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    public SearchResult(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public List<Hit> getHits() {
        if (this.closed) {
            throw new IllegalStateException("SearchResult has been closed");
        }
        return SearchResult.nativeGetHits(this.nativePtr);
    }

    public boolean hasAggregations() {
        if (this.closed) {
            throw new IllegalStateException("SearchResult has been closed");
        }
        return SearchResult.nativeHasAggregations(this.nativePtr);
    }

    public Map<String, AggregationResult> getAggregations() {
        if (this.closed) {
            throw new IllegalStateException("SearchResult has been closed");
        }
        return SearchResult.nativeGetAggregations(this.nativePtr);
    }

    public AggregationResult getAggregation(String name) {
        if (this.closed) {
            throw new IllegalStateException("SearchResult has been closed");
        }
        return SearchResult.nativeGetAggregation(this.nativePtr, name);
    }

    @Override
    public void close() {
        if (!this.closed) {
            SearchResult.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    private static native List<Hit> nativeGetHits(long var0);

    private static native boolean nativeHasAggregations(long var0);

    private static native Map<String, AggregationResult> nativeGetAggregations(long var0);

    private static native AggregationResult nativeGetAggregation(long var0, String var2);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }

    public static class Hit {
        private final double score;
        private final DocAddress docAddress;

        public Hit(double score, DocAddress docAddress) {
            this.score = score;
            this.docAddress = docAddress;
        }

        public double getScore() {
            return this.score;
        }

        public DocAddress getDocAddress() {
            return this.docAddress;
        }

        public String toString() {
            return String.format("Hit{score=%.4f, docAddress=%s}", this.score, this.docAddress);
        }
    }
}

