/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.query;

import io.indextables.tantivy4java.core.Document;
import io.indextables.tantivy4java.core.Schema;
import io.indextables.tantivy4java.core.Searcher;
import io.indextables.tantivy4java.core.Tantivy;
import io.indextables.tantivy4java.query.Query;
import io.indextables.tantivy4java.query.Snippet;

public class SnippetGenerator
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    SnippetGenerator(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public static SnippetGenerator create(Searcher searcher, Query query, Schema schema, String fieldName) {
        long ptr = SnippetGenerator.nativeCreate(searcher.getNativePtr(), query.getNativePtr(), schema.getNativePtr(), fieldName);
        return new SnippetGenerator(ptr);
    }

    public Snippet snippetFromDoc(Document doc) {
        if (this.closed) {
            throw new IllegalStateException("SnippetGenerator has been closed");
        }
        long ptr = SnippetGenerator.nativeSnippetFromDoc(this.nativePtr, doc.getNativePtr());
        return new Snippet(ptr);
    }

    public void setMaxNumChars(int maxNumChars) {
        if (this.closed) {
            throw new IllegalStateException("SnippetGenerator has been closed");
        }
        if (maxNumChars <= 0) {
            throw new IllegalArgumentException("maxNumChars must be positive");
        }
        SnippetGenerator.nativeSetMaxNumChars(this.nativePtr, maxNumChars);
    }

    long getNativePtr() {
        if (this.closed) {
            throw new IllegalStateException("SnippetGenerator has been closed");
        }
        return this.nativePtr;
    }

    @Override
    public void close() {
        if (!this.closed) {
            SnippetGenerator.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    private static native long nativeCreate(long var0, long var2, long var4, String var6);

    private static native long nativeSnippetFromDoc(long var0, long var2);

    private static native void nativeSetMaxNumChars(long var0, int var2);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }
}

