/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.query;

import io.indextables.tantivy4java.core.Tantivy;
import io.indextables.tantivy4java.query.Range;
import java.util.List;

public class Snippet
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    Snippet(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public String toHtml() {
        if (this.closed) {
            throw new IllegalStateException("Snippet has been closed");
        }
        return Snippet.nativeToHtml(this.nativePtr);
    }

    public List<Range> getHighlighted() {
        if (this.closed) {
            throw new IllegalStateException("Snippet has been closed");
        }
        return Snippet.nativeGetHighlighted(this.nativePtr);
    }

    public String getFragment() {
        if (this.closed) {
            throw new IllegalStateException("Snippet has been closed");
        }
        return Snippet.nativeGetFragment(this.nativePtr);
    }

    long getNativePtr() {
        if (this.closed) {
            throw new IllegalStateException("Snippet has been closed");
        }
        return this.nativePtr;
    }

    @Override
    public void close() {
        if (!this.closed) {
            Snippet.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    public String toString() {
        if (this.closed) {
            return "Snippet[closed]";
        }
        return "Snippet[" + this.getFragment() + "]";
    }

    private static native String nativeToHtml(long var0);

    private static native List<Range> nativeGetHighlighted(long var0);

    private static native String nativeGetFragment(long var0);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }
}

