/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.query;

import io.indextables.tantivy4java.core.Tantivy;

public class Range
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    Range(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public int getStart() {
        if (this.closed) {
            throw new IllegalStateException("Range has been closed");
        }
        return Range.nativeGetStart(this.nativePtr);
    }

    public int getEnd() {
        if (this.closed) {
            throw new IllegalStateException("Range has been closed");
        }
        return Range.nativeGetEnd(this.nativePtr);
    }

    long getNativePtr() {
        if (this.closed) {
            throw new IllegalStateException("Range has been closed");
        }
        return this.nativePtr;
    }

    @Override
    public void close() {
        if (!this.closed) {
            Range.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    public String toString() {
        if (this.closed) {
            return "Range[closed]";
        }
        return "Range[" + this.getStart() + ", " + this.getEnd() + "]";
    }

    private static native int nativeGetStart(long var0);

    private static native int nativeGetEnd(long var0);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }
}

