/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.query;

import io.indextables.tantivy4java.core.DocAddress;
import io.indextables.tantivy4java.core.FieldType;
import io.indextables.tantivy4java.core.Schema;
import io.indextables.tantivy4java.core.Searcher;
import io.indextables.tantivy4java.core.Tantivy;
import io.indextables.tantivy4java.query.Explanation;
import io.indextables.tantivy4java.query.Occur;
import java.util.List;

public class Query
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    public Query(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public static Query termQuery(Schema schema, String fieldName, Object fieldValue, String indexOption) {
        long ptr = Query.nativeTermQuery(schema.getNativePtr(), fieldName, fieldValue, indexOption);
        return new Query(ptr);
    }

    public static Query termQuery(Schema schema, String fieldName, Object fieldValue) {
        return Query.termQuery(schema, fieldName, fieldValue, "position");
    }

    public static Query termSetQuery(Schema schema, String fieldName, List<Object> fieldValues) {
        long ptr = Query.nativeTermSetQuery(schema.getNativePtr(), fieldName, fieldValues);
        return new Query(ptr);
    }

    public static Query allQuery() {
        long ptr = Query.nativeAllQuery();
        return new Query(ptr);
    }

    public static Query fuzzyTermQuery(Schema schema, String fieldName, String text, int distance, boolean transpositionCostOne, boolean prefix) {
        long ptr = Query.nativeFuzzyTermQuery(schema.getNativePtr(), fieldName, text, distance, transpositionCostOne, prefix);
        return new Query(ptr);
    }

    public static Query fuzzyTermQuery(Schema schema, String fieldName, String text) {
        return Query.fuzzyTermQuery(schema, fieldName, text, 1, true, false);
    }

    public static Query phraseQuery(Schema schema, String fieldName, List<Object> words, int slop) {
        long ptr = Query.nativePhraseQuery(schema.getNativePtr(), fieldName, words, slop);
        return new Query(ptr);
    }

    public static Query phraseQuery(Schema schema, String fieldName, List<Object> words) {
        return Query.phraseQuery(schema, fieldName, words, 0);
    }

    public static Query booleanQuery(List<OccurQuery> subqueries) {
        long ptr = Query.nativeBooleanQuery(subqueries);
        return new Query(ptr);
    }

    public static Query disjunctionMaxQuery(List<Query> subqueries, Double tieBreaker) {
        long[] ptrs = subqueries.stream().mapToLong(q -> q.getNativePtr()).toArray();
        long ptr = Query.nativeDisjunctionMaxQuery(ptrs, tieBreaker);
        return new Query(ptr);
    }

    public static Query disjunctionMaxQuery(List<Query> subqueries) {
        return Query.disjunctionMaxQuery(subqueries, null);
    }

    public static Query boostQuery(Query query, double boost) {
        long ptr = Query.nativeBoostQuery(query.getNativePtr(), boost);
        return new Query(ptr);
    }

    public static Query regexQuery(Schema schema, String fieldName, String regexPattern) {
        long ptr = Query.nativeRegexQuery(schema.getNativePtr(), fieldName, regexPattern);
        return new Query(ptr);
    }

    public static Query wildcardQuery(Schema schema, String fieldName, String pattern) {
        long ptr = Query.nativeWildcardQuery(schema.getNativePtr(), fieldName, pattern);
        return new Query(ptr);
    }

    public static Query wildcardQuery(Schema schema, String fieldName, String pattern, boolean lenient) {
        long ptr = Query.nativeWildcardQueryLenient(schema.getNativePtr(), fieldName, pattern, lenient);
        return new Query(ptr);
    }

    public static Query moreLikeThisQuery(DocAddress docAddress, Integer minDocFrequency, Integer maxDocFrequency, Integer minTermFrequency, Integer maxQueryTerms, Integer minWordLength, Integer maxWordLength, Double boostFactor, List<String> stopWords) {
        long ptr = Query.nativeMoreLikeThisQuery(docAddress.getNativePtr(), minDocFrequency, maxDocFrequency, minTermFrequency, maxQueryTerms, minWordLength, maxWordLength, boostFactor, stopWords);
        return new Query(ptr);
    }

    public static Query moreLikeThisQuery(DocAddress docAddress) {
        return Query.moreLikeThisQuery(docAddress, 5, null, 2, 25, null, null, 1.0, List.of());
    }

    public static Query constScoreQuery(Query query, double score) {
        long ptr = Query.nativeConstScoreQuery(query.getNativePtr(), score);
        return new Query(ptr);
    }

    public static Query rangeQuery(Schema schema, String fieldName, FieldType fieldType, Object lowerBound, Object upperBound, boolean includeLower, boolean includeUpper) {
        long ptr = Query.nativeRangeQuery(schema.getNativePtr(), fieldName, fieldType.getValue(), lowerBound, upperBound, includeLower, includeUpper);
        return new Query(ptr);
    }

    public static Query rangeQuery(Schema schema, String fieldName, FieldType fieldType, Object lowerBound, Object upperBound) {
        return Query.rangeQuery(schema, fieldName, fieldType, lowerBound, upperBound, true, true);
    }

    public Explanation explain(Searcher searcher, DocAddress docAddress) {
        if (this.closed) {
            throw new IllegalStateException("Query has been closed");
        }
        long ptr = Query.nativeExplain(this.nativePtr, searcher.getNativePtr(), docAddress.getNativePtr());
        return new Explanation(ptr);
    }

    public long getNativePtr() {
        if (this.closed) {
            throw new IllegalStateException("Query has been closed");
        }
        return this.nativePtr;
    }

    @Override
    public void close() {
        if (!this.closed) {
            Query.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    public String toString() {
        if (this.closed) {
            return "Query{CLOSED}";
        }
        return Query.nativeToString(this.nativePtr);
    }

    private static native long nativeTermQuery(long var0, String var2, Object var3, String var4);

    private static native long nativeTermSetQuery(long var0, String var2, List<Object> var3);

    private static native long nativeAllQuery();

    private static native long nativeFuzzyTermQuery(long var0, String var2, String var3, int var4, boolean var5, boolean var6);

    private static native long nativePhraseQuery(long var0, String var2, List<Object> var3, int var4);

    private static native long nativeBooleanQuery(List<OccurQuery> var0);

    private static native long nativeDisjunctionMaxQuery(long[] var0, Double var1);

    private static native long nativeBoostQuery(long var0, double var2);

    private static native long nativeRegexQuery(long var0, String var2, String var3);

    private static native long nativeWildcardQuery(long var0, String var2, String var3);

    private static native long nativeWildcardQueryLenient(long var0, String var2, String var3, boolean var4);

    private static native long nativeMoreLikeThisQuery(long var0, Integer var2, Integer var3, Integer var4, Integer var5, Integer var6, Integer var7, Double var8, List<String> var9);

    private static native long nativeConstScoreQuery(long var0, double var2);

    private static native long nativeRangeQuery(long var0, String var2, int var3, Object var4, Object var5, boolean var6, boolean var7);

    private static native long nativeExplain(long var0, long var2, long var4);

    private static native String nativeToString(long var0);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }

    public static class OccurQuery {
        private final Occur occur;
        private final Query query;

        public OccurQuery(Occur occur, Query query) {
            this.occur = occur;
            this.query = query;
        }

        public Occur getOccur() {
            return this.occur;
        }

        public Query getQuery() {
            return this.query;
        }
    }
}

