/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.examples;

import io.indextables.tantivy4java.core.Document;
import io.indextables.tantivy4java.core.Index;
import io.indextables.tantivy4java.core.IndexWriter;
import io.indextables.tantivy4java.core.Schema;
import io.indextables.tantivy4java.core.SchemaBuilder;
import io.indextables.tantivy4java.core.Searcher;
import io.indextables.tantivy4java.query.Query;
import io.indextables.tantivy4java.result.SearchResult;
import io.indextables.tantivy4java.split.merge.QuickwitSplit;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Random;

public class QuickwitSplitExample {
    public static void main(String[] args) {
        try {
            System.out.println("\ud83d\ude80 QuickwitSplit Example: Converting Tantivy Index to Quickwit Split");
            System.out.println("==================================================================");
            Path outputDir = Paths.get("/tmp/splitexample", new String[0]);
            Files.createDirectories(outputDir, new FileAttribute[0]);
            System.out.println("\ud83d\udcc1 Created output directory: " + String.valueOf(outputDir));
            Path indexDir = Files.createTempDirectory("tantivy_example_index", new FileAttribute[0]);
            System.out.println("\ud83d\udcc1 Created temporary index directory: " + String.valueOf(indexDir));
            try (SchemaBuilder builder = new SchemaBuilder();){
                builder.addTextField("title", true, false, "default", "position").addTextField("content", true, false, "default", "position").addTextField("category", true, true, "default", "").addIntegerField("id", true, true, true).addFloatField("rating", true, true, true).addBooleanField("is_published", true, true, true);
                try (Schema schema = builder.build();){
                    System.out.println("\ud83d\udcdd Created schema with 6 fields");
                    try (Index index = new Index(schema, indexDir.toString(), false);){
                        Object title;
                        System.out.println("\ud83d\uddc2\ufe0f Created Tantivy index at: " + String.valueOf(indexDir));
                        try (IndexWriter writer = index.writer(500, 1);){
                            Random random = new Random(42L);
                            String[] categories = new String[]{"tech", "science", "business", "health", "education", "entertainment"};
                            String[] titleWords = new String[]{"Advanced", "Introduction", "Complete", "Comprehensive", "Modern", "Essential", "Ultimate", "Practical"};
                            String[] contentWords = new String[]{"analysis", "development", "research", "implementation", "optimization", "innovation", "methodology", "framework"};
                            System.out.println("\ud83d\udcc4 Adding documents to index...");
                            for (int i = 1; i <= 250; ++i) {
                                String category = categories[random.nextInt(categories.length)];
                                title = titleWords[random.nextInt(titleWords.length)] + " " + category + " " + titleWords[random.nextInt(titleWords.length)];
                                String content = QuickwitSplitExample.generateContent(contentWords, random, 50);
                                float rating = 1.0f + random.nextFloat() * 4.0f;
                                boolean isPublished = random.nextBoolean();
                                String jsonDoc = String.format("{ \"id\": %d, \"title\": \"%s\", \"content\": \"%s\", \"category\": \"%s\", \"rating\": %.2f, \"is_published\": %s }", i, title, content, category, Float.valueOf(rating), isPublished);
                                writer.addJson(jsonDoc);
                                if (i % 50 != 0) continue;
                                System.out.println("  \u2705 Added " + i + " documents");
                            }
                            writer.commit();
                            System.out.println("\ud83d\udcbe Committed 250 documents to index");
                        }
                        index.reload();
                        try (Searcher searcher = index.searcher();){
                            int numDocs = searcher.getNumDocs();
                            System.out.println("\ud83d\udd0d Index contains " + numDocs + " documents");
                            try (Query query = Query.termQuery(schema, "category", "tech");
                                 SearchResult result = searcher.search(query, 5);){
                                System.out.println("\ud83d\udcca Sample search results for 'tech' category:");
                                for (SearchResult.Hit hit : result.getHits()) {
                                    Document doc = searcher.doc(hit.getDocAddress());
                                    try {
                                        title = (String)doc.get("title").get(0);
                                        long id = (Long)doc.get("id").get(0);
                                        System.out.println("  - [" + id + "] " + (String)title + " (score: " + String.format("%.3f", hit.getScore()) + ")");
                                    }
                                    finally {
                                        if (doc == null) continue;
                                        doc.close();
                                    }
                                }
                            }
                        }
                        System.out.println("\n\ud83d\udd04 Converting Tantivy index to Quickwit split...");
                        QuickwitSplit.SplitConfig config = new QuickwitSplit.SplitConfig("example-index-2024", "demo-source", "example-node-1");
                        Path splitPath = outputDir.resolve("example_index.split");
                        QuickwitSplit.SplitMetadata metadata = QuickwitSplit.convertIndex(index, splitPath.toString(), config);
                        System.out.println("\u2705 Successfully converted to Quickwit split!");
                        System.out.println("\ud83d\udcca Split Metadata:");
                        System.out.println("  - Split ID: " + metadata.getSplitId());
                        System.out.println("  - Document Count: " + metadata.getNumDocs());
                        System.out.println("  - Uncompressed Size: " + metadata.getUncompressedSizeBytes() + " bytes");
                        System.out.println("  - Delete Opstamp: " + metadata.getDeleteOpstamp());
                        System.out.println("  - Merge Operations: " + metadata.getNumMergeOps());
                        System.out.println("\n\ud83d\udcc2 Files contained in the split:");
                        List<String> splitFiles = QuickwitSplit.listSplitFiles(splitPath.toString());
                        for (String file : splitFiles) {
                            System.out.println("  - " + file);
                        }
                        boolean isValid = QuickwitSplit.validateSplit(splitPath.toString());
                        System.out.println("\n\u2705 Split validation: " + (isValid ? "PASSED" : "FAILED"));
                        System.out.println("\n\ud83d\udcc1 Output files created:");
                        System.out.println("  - Split file: " + String.valueOf(splitPath));
                        System.out.println("  - File size: " + Files.size(splitPath) + " bytes");
                        System.out.println("  - Directory: " + String.valueOf(outputDir));
                        System.out.println("\n\ud83c\udf89 Example completed successfully!");
                        System.out.println("\ud83d\udca1 You can find the split files in: " + String.valueOf(outputDir));
                        System.out.println("\ud83d\udca1 The split file can be used with Quickwit for distributed search");
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u274c Error running QuickwitSplit example: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String generateContent(String[] words, Random random, int wordCount) {
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < wordCount; ++i) {
            if (i > 0) {
                content.append(" ");
            }
            content.append(words[random.nextInt(words.length)]);
        }
        return content.toString();
    }
}

