/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.examples;

import io.indextables.tantivy4java.core.Document;
import io.indextables.tantivy4java.core.FieldType;
import io.indextables.tantivy4java.core.Index;
import io.indextables.tantivy4java.core.IndexWriter;
import io.indextables.tantivy4java.core.Schema;
import io.indextables.tantivy4java.core.SchemaBuilder;
import io.indextables.tantivy4java.core.Searcher;
import io.indextables.tantivy4java.query.Query;
import io.indextables.tantivy4java.result.SearchResult;
import io.indextables.tantivy4java.split.merge.QuickwitSplit;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Random;

public class QuickwitIndexExample {
    public static void main(String[] args) {
        try {
            System.out.println("\ud83d\ude80 Creating Quickwit-Compatible Index with 50 Documents");
            System.out.println("======================================================");
            Path indexDir = Paths.get("/tmp/exampleindex", new String[0]);
            Files.createDirectories(indexDir, new FileAttribute[0]);
            System.out.println("\ud83d\udcc1 Created index directory: " + String.valueOf(indexDir));
            try (SchemaBuilder builder = new SchemaBuilder();){
                builder.addTextField("message", true, false, "default", "position").addTextField("service", true, true, "default", "").addTextField("level", true, true, "default", "").addTextField("host", true, true, "default", "").addTextField("environment", true, true, "default", "").addIntegerField("status_code", true, true, true).addFloatField("response_time", true, true, true).addTextField("user_id", true, true, "default", "").addTextField("request_path", true, true, "default", "").addBooleanField("is_error", true, true, true);
                try (Schema schema = builder.build();){
                    System.out.println("\ud83d\udcdd Created schema with 10 fields suitable for log data");
                    try (Index index = new Index(schema, indexDir.toString(), false);){
                        System.out.println("\ud83d\uddc2\ufe0f Created Tantivy index at: " + String.valueOf(indexDir));
                        try (IndexWriter writer = index.writer(100, 1);){
                            Random random = new Random(12345L);
                            String[] services = new String[]{"user-service", "payment-service", "notification-service", "auth-service", "api-gateway"};
                            String[] levels = new String[]{"INFO", "WARN", "ERROR", "DEBUG"};
                            String[] hosts = new String[]{"web-01", "web-02", "api-01", "api-02", "worker-01"};
                            String[] environments = new String[]{"production", "staging", "development"};
                            String[] paths = new String[]{"/api/users", "/api/payments", "/api/auth/login", "/api/notifications", "/health"};
                            String[] userIds = new String[]{"user_001", "user_002", "user_003", "user_004", "user_005", "anonymous"};
                            String[] messageTemplates = new String[]{"Successfully processed request for user %s", "Failed to connect to database: timeout after 30s", "User authentication successful", "Payment processed successfully: $%.2f", "Cache miss for key: %s", "Rate limit exceeded for IP: %s", "Service health check passed", "Background job completed in %.1fms", "Invalid request parameters received", "Database connection pool exhausted"};
                            System.out.println("\ud83d\udcc4 Adding 50 documents to index...");
                            for (int i = 1; i <= 50; ++i) {
                                boolean isError;
                                int statusCode;
                                String service = services[random.nextInt(services.length)];
                                String level = levels[random.nextInt(levels.length)];
                                String host = hosts[random.nextInt(hosts.length)];
                                String environment = environments[random.nextInt(environments.length)];
                                String path = paths[random.nextInt(paths.length)];
                                String userId = userIds[random.nextInt(userIds.length)];
                                switch (level) {
                                    case "ERROR": {
                                        statusCode = 500 + random.nextInt(99);
                                        isError = true;
                                        break;
                                    }
                                    case "WARN": {
                                        statusCode = random.nextBoolean() ? 400 + random.nextInt(99) : 200;
                                        isError = statusCode >= 400;
                                        break;
                                    }
                                    default: {
                                        statusCode = random.nextBoolean() ? 200 : 200 + random.nextInt(99);
                                        isError = false;
                                    }
                                }
                                float responseTime = isError ? 500.0f + random.nextFloat() * 2000.0f : 10.0f + random.nextFloat() * 200.0f;
                                String messageTemplate = messageTemplates[random.nextInt(messageTemplates.length)];
                                String message = messageTemplate.contains("%s") ? String.format(messageTemplate, userId) : (messageTemplate.contains("%.2f") ? String.format(messageTemplate, Float.valueOf(responseTime * 10.0f)) : (messageTemplate.contains("%.1f") ? String.format(messageTemplate, Float.valueOf(responseTime)) : messageTemplate));
                                String jsonDoc = String.format("{ \"message\": \"%s\", \"service\": \"%s\", \"level\": \"%s\", \"host\": \"%s\", \"environment\": \"%s\", \"status_code\": %d, \"response_time\": %.2f, \"user_id\": \"%s\", \"request_path\": \"%s\", \"is_error\": %s }", message.replace("\"", "\\\""), service, level, host, environment, statusCode, Float.valueOf(responseTime), userId, path, isError);
                                writer.addJson(jsonDoc);
                                if (i % 10 != 0) continue;
                                System.out.println("  \u2705 Added " + i + " documents");
                            }
                            writer.commit();
                            System.out.println("\ud83d\udcbe Committed 50 documents to index");
                        }
                        index.reload();
                        try (Searcher searcher = index.searcher();){
                            Document doc;
                            int numDocs = searcher.getNumDocs();
                            System.out.println("\ud83d\udd0d Index contains " + numDocs + " documents");
                            System.out.println("\n\ud83d\udcca Sample search results:");
                            try (Query errorQuery = Query.termQuery(schema, "is_error", true);
                                 SearchResult errorResult = searcher.search(errorQuery, 5);){
                                System.out.println("\n\ud83d\udd34 Error entries found: " + errorResult.getHits().size());
                                for (SearchResult.Hit hit : errorResult.getHits()) {
                                    doc = searcher.doc(hit.getDocAddress());
                                    try {
                                        String message = (String)doc.get("message").get(0);
                                        String service = (String)doc.get("service").get(0);
                                        long statusCode = (Long)doc.get("status_code").get(0);
                                        System.out.println("  - [" + service + "] " + statusCode + ": " + (String)(message.length() > 60 ? message.substring(0, 57) + "..." : message));
                                    }
                                    finally {
                                        if (doc == null) continue;
                                        doc.close();
                                    }
                                }
                            }
                            try (Query serviceQuery = Query.termQuery(schema, "service", "user-service");
                                 SearchResult serviceResult = searcher.search(serviceQuery, 3);){
                                System.out.println("\n\ud83d\udc64 User service entries found: " + serviceResult.getHits().size());
                                for (SearchResult.Hit hit : serviceResult.getHits()) {
                                    doc = searcher.doc(hit.getDocAddress());
                                    try {
                                        String level = (String)doc.get("level").get(0);
                                        String message = (String)doc.get("message").get(0);
                                        System.out.println("  - [" + level + "] " + (String)(message.length() > 50 ? message.substring(0, 47) + "..." : message));
                                    }
                                    finally {
                                        if (doc == null) continue;
                                        doc.close();
                                    }
                                }
                            }
                            try (Query slowQuery = Query.rangeQuery(schema, "response_time", FieldType.FLOAT, 1000.0, Double.MAX_VALUE, true, false);
                                 SearchResult slowResult = searcher.search(slowQuery, 3);){
                                System.out.println("\n\ud83d\udc0c Slow requests (>1000ms) found: " + slowResult.getHits().size());
                                for (SearchResult.Hit hit : slowResult.getHits()) {
                                    doc = searcher.doc(hit.getDocAddress());
                                    try {
                                        String service = (String)doc.get("service").get(0);
                                        double responseTime = (Double)doc.get("response_time").get(0);
                                        String path = (String)doc.get("request_path").get(0);
                                        System.out.println("  - " + service + " " + path + ": " + String.format("%.1fms", responseTime));
                                    }
                                    finally {
                                        if (doc == null) continue;
                                        doc.close();
                                    }
                                }
                            }
                            System.out.println("\n\ud83d\udcc8 Index Statistics:");
                            System.out.println("  - Total documents: " + numDocs);
                            System.out.println("  - Index directory: " + String.valueOf(indexDir));
                            System.out.println("  - Index files created: " + Files.list(indexDir).count() + " files");
                            System.out.println("\n\ud83d\udcc2 Index files created:");
                            Files.list(indexDir).forEach(file -> System.out.println("  - " + String.valueOf(file.getFileName()) + " (" + QuickwitIndexExample.getFileSize(file) + " bytes)"));
                        }
                        System.out.println("\n\ud83d\udd04 Converting Tantivy index to Quickwit split...");
                        QuickwitSplit.SplitConfig config = new QuickwitSplit.SplitConfig("example-logs-2024", "log-ingestion", "indexer-node-1");
                        Path splitPath = indexDir.resolve("logs.split");
                        QuickwitSplit.SplitMetadata splitMetadata = QuickwitSplit.convertIndex(index, splitPath.toString(), config);
                        System.out.println("\u2705 Successfully converted to Quickwit split!");
                        System.out.println("\ud83d\udcca Split Metadata:");
                        System.out.println("  - Split ID: " + splitMetadata.getSplitId());
                        System.out.println("  - Document Count: " + splitMetadata.getNumDocs());
                        System.out.println("  - Uncompressed Size: " + splitMetadata.getUncompressedSizeBytes() + " bytes");
                        System.out.println("  - Delete Opstamp: " + splitMetadata.getDeleteOpstamp());
                        System.out.println("  - Merge Operations: " + splitMetadata.getNumMergeOps());
                        System.out.println("\n\ud83d\udcc2 Files contained in the split:");
                        List<String> splitFiles = QuickwitSplit.listSplitFiles(splitPath.toString());
                        for (String file2 : splitFiles) {
                            System.out.println("  - " + file2);
                        }
                        boolean isValid = QuickwitSplit.validateSplit(splitPath.toString());
                        System.out.println("\n\u2705 Split validation: " + (isValid ? "PASSED" : "FAILED"));
                        System.out.println("\n\ud83d\udcc1 Final directory structure:");
                        Files.list(indexDir).forEach(file -> {
                            String fileName = file.getFileName().toString();
                            long fileSize = QuickwitIndexExample.getFileSize(file);
                            String fileType = fileName.endsWith(".split") ? " (Quickwit Split)" : (fileName.startsWith(".") ? " (Lock/Meta)" : " (Tantivy Index)");
                            System.out.println("  - " + fileName + " (" + fileSize + " bytes)" + fileType);
                        });
                        System.out.println("\n\ud83c\udf89 Quickwit split creation completed successfully!");
                        System.out.println("\ud83d\udca1 Index location: " + String.valueOf(indexDir));
                        System.out.println("\ud83d\udca1 Split file: " + String.valueOf(splitPath));
                        System.out.println("\ud83d\udca1 The split file contains all index data and can be used with Quickwit");
                        System.out.println("\ud83d\udca1 Split file includes hotcache-compatible format ready for distributed search");
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u274c Error creating Quickwit index: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static long getFileSize(Path file) {
        try {
            return Files.size(file);
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

