/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.examples;

import io.indextables.tantivy4java.config.FileSystemConfig;
import io.indextables.tantivy4java.core.Document;
import io.indextables.tantivy4java.core.Index;
import io.indextables.tantivy4java.core.IndexWriter;
import io.indextables.tantivy4java.core.Schema;
import io.indextables.tantivy4java.core.SchemaBuilder;
import io.indextables.tantivy4java.split.SplitCacheManager;
import io.indextables.tantivy4java.split.SplitSearcher;
import io.indextables.tantivy4java.split.merge.QuickwitSplit;
import java.io.File;

public class FileSystemRootExample {
    public static void main(String[] args) throws Exception {
        System.out.println("\ud83d\uddc2\ufe0f  Tantivy4Java File System Root Configuration Example");
        System.out.println("====================================================");
        File tempDir = new File(System.getProperty("java.io.tmpdir"), "tantivy4java-example");
        tempDir.mkdirs();
        try {
            FileSystemRootExample.demonstrateFileSystemRoot(tempDir.getAbsolutePath());
        }
        finally {
            FileSystemRootExample.deleteDirectory(tempDir);
        }
    }

    private static void demonstrateFileSystemRoot(String rootPath) throws Exception {
        Schema schema;
        System.out.println("\n1. \ud83d\udcc1 Setting up file system root");
        System.out.println("   Root directory: " + rootPath);
        FileSystemConfig.setGlobalRoot(rootPath);
        System.out.println("   \u2705 File system root configured");
        System.out.println("   \ud83d\udcca " + FileSystemConfig.getConfigSummary());
        System.out.println("\n2. \ud83d\udccb Creating search schema");
        try (SchemaBuilder builder = new SchemaBuilder();){
            builder.addTextField("title", true, false, "default", "position");
            builder.addTextField("content", false, false, "default", "position");
            schema = builder.build();
        }
        System.out.println("   \u2705 Schema created with text fields");
        String indexPath = "my-search-index";
        System.out.println("\n3. \ud83d\udd0d Creating search index at relative path: " + indexPath);
        try (Index index = new Index(schema, indexPath, false);){
            System.out.println("   \u2705 Index created");
            System.out.println("   \ud83d\udccd Resolved path: " + index.getIndexPath());
            System.out.println("\n4. \ud83d\udcdd Adding documents to index");
            try (IndexWriter writer = index.writer(50000000, 1);){
                Document doc1 = new Document();
                doc1.addText("title", "Introduction to Search");
                doc1.addText("content", "Search engines help users find information quickly");
                writer.addDocument(doc1);
                Document doc2 = new Document();
                doc2.addText("title", "Advanced Search Techniques");
                doc2.addText("content", "Boolean queries and field-specific searches");
                writer.addDocument(doc2);
                writer.commit();
                System.out.println("   \u2705 Added 2 documents and committed");
            }
            System.out.println("\n5. \ud83d\udd0d Testing index operations");
            boolean exists = Index.exists(indexPath);
            System.out.println("   \u2705 Index exists check (relative path): " + exists);
            System.out.println("\n6. \ud83d\udce6 Converting to Quickwit split");
            QuickwitSplit.SplitConfig splitConfig = new QuickwitSplit.SplitConfig("example-index", "example-source", "example-node");
            String splitPath = "example.split";
            QuickwitSplit.SplitMetadata splitMetadata = QuickwitSplit.convertIndexFromPath(indexPath, splitPath, splitConfig);
            System.out.println("   \u2705 Split created at relative path: " + splitPath);
            System.out.println("   \ud83d\udcca Documents in split: " + splitMetadata.getNumDocs());
            boolean isValid = QuickwitSplit.validateSplit(splitPath);
            System.out.println("   \u2705 Split validation: " + isValid);
            System.out.println("\n7. \ud83d\udd0d Testing split search");
            SplitCacheManager.CacheConfig cacheConfig = new SplitCacheManager.CacheConfig("example-cache").withMaxCacheSize(50000000L);
            try (SplitCacheManager cacheManager = SplitCacheManager.getInstance(cacheConfig);){
                SplitSearcher splitSearcher = cacheManager.createSplitSearcher(splitPath, splitMetadata);
                System.out.println("   \u2705 SplitSearcher created successfully");
                System.out.println("   \ud83d\udcca Split path: " + splitPath);
                System.out.println("   \ud83d\udcca Split contains " + splitMetadata.getNumDocs() + " documents");
            }
            System.out.println("\n8. \ud83d\udd12 Demonstrating path security");
            try {
                String maliciousPath = "../../../etc/passwd";
                FileSystemConfig.resolvePath(maliciousPath);
                System.out.println("   \u274c Security check failed - path traversal not prevented!");
            }
            catch (IllegalArgumentException e) {
                System.out.println("   \u2705 Security check passed - path traversal prevented");
                System.out.println("   \ud83d\udee1\ufe0f  Protected against: ../../../etc/passwd");
            }
        }
        System.out.println("\n9. \ud83d\udd04 Clearing file system root");
        FileSystemConfig.clearGlobalRoot();
        System.out.println("   \u2705 File system root cleared");
        System.out.println("   \ud83d\udcca " + FileSystemConfig.getConfigSummary());
        System.out.println("\n\ud83c\udf89 Example completed successfully!");
        System.out.println("\n\ud83d\udca1 Key Benefits:");
        System.out.println("   \u2022 \ud83d\udd12 Security: Prevents path traversal attacks");
        System.out.println("   \u2022 \ud83d\udce6 Containerization: Easy volume mapping");
        System.out.println("   \u2022 \ud83c\udfe2 Multi-tenancy: Isolated file operations");
        System.out.println("   \u2022 \ud83c\udfaf Simplicity: Use relative paths everywhere");
    }

    private static void deleteDirectory(File directory) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                FileSystemRootExample.deleteDirectory(file);
            }
        }
        directory.delete();
    }
}

