/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.examples;

import io.indextables.tantivy4java.core.Document;
import io.indextables.tantivy4java.core.FieldType;
import io.indextables.tantivy4java.core.Index;
import io.indextables.tantivy4java.core.IndexWriter;
import io.indextables.tantivy4java.core.Schema;
import io.indextables.tantivy4java.core.SchemaBuilder;
import io.indextables.tantivy4java.core.Searcher;
import io.indextables.tantivy4java.core.Tantivy;
import io.indextables.tantivy4java.query.Occur;
import io.indextables.tantivy4java.query.Query;
import io.indextables.tantivy4java.result.SearchResult;
import java.util.List;

public class BasicExample {
    public static void main(String[] args) {
        System.out.println("Tantivy4Java Basic Example");
        System.out.println("Version: " + BasicExample.getVersionSafely());
        try {
            BasicExample.createAndSearchIndex();
        }
        catch (Exception e) {
            System.err.println("Expected error (native implementation not complete): " + e.getMessage());
        }
    }

    private static String getVersionSafely() {
        try {
            return Tantivy.getVersion();
        }
        catch (Exception e) {
            return "Unknown (native library not loaded)";
        }
    }

    private static void createAndSearchIndex() {
        try (SchemaBuilder builder = new SchemaBuilder();){
            builder.addTextField("title", true, false, "default", "position").addTextField("body", true, false, "default", "position").addIntegerField("year", true, true, false);
            try (Schema schema = builder.build();
                 Index index = new Index(schema);){
                try (IndexWriter writer = index.writer();){
                    Document doc1 = new Document();
                    doc1.addText("title", "The Old Man and the Sea");
                    doc1.addText("body", "A story of an old fisherman's struggle with a giant marlin");
                    doc1.addInteger("year", 1952L);
                    writer.addDocument(doc1);
                    Document doc2 = new Document();
                    doc2.addText("title", "Of Mice and Men");
                    doc2.addText("body", "A story of two displaced migrant workers");
                    doc2.addInteger("year", 1937L);
                    writer.addDocument(doc2);
                    Document doc3 = new Document();
                    doc3.addText("title", "The Great Gatsby");
                    doc3.addText("body", "A story of the Jazz Age and the American Dream");
                    doc3.addInteger("year", 1925L);
                    writer.addDocument(doc3);
                    writer.commit();
                }
                try (Searcher searcher = index.searcher();){
                    System.out.println("Total documents: " + searcher.getNumDocs());
                    Query query = Query.termQuery(schema, "body", "story");
                    SearchResult result = searcher.search(query, 10);
                    System.out.println("Found " + result.getHits().size() + " documents for 'story'");
                    Query termQuery1 = Query.termQuery(schema, "body", "story");
                    Query termQuery2 = Query.termQuery(schema, "title", "Old");
                    Query boolQuery = Query.booleanQuery(List.of(new Query.OccurQuery(Occur.MUST, termQuery1), new Query.OccurQuery(Occur.MUST, termQuery2)));
                    SearchResult boolResult = searcher.search(boolQuery, 10);
                    System.out.println("Boolean query results: " + boolResult.getHits().size());
                    Query rangeQuery = Query.rangeQuery(schema, "year", FieldType.INTEGER, 1930, 1950, true, true);
                    SearchResult rangeResult = searcher.search(rangeQuery, 10);
                    System.out.println("Books published 1930-1950: " + rangeResult.getHits().size());
                }
            }
        }
    }
}

