/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.core;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class Tantivy {
    private static boolean loaded = false;

    private static synchronized void loadNativeLibrary() {
        if (loaded) {
            return;
        }
        String osName = Tantivy.detectOS();
        String libraryName = osName.contains("windows") ? "tantivy4java.dll" : (osName.contains("mac") || osName.contains("darwin") ? "libtantivy4java.dylib" : "libtantivy4java.so");
        try {
            InputStream is = Tantivy.class.getResourceAsStream("/native/" + libraryName);
            if (is != null) {
                Path tempFile = Files.createTempFile("tantivy4java", libraryName, new FileAttribute[0]);
                Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
                System.load(tempFile.toAbsolutePath().toString());
                loaded = true;
                return;
            }
            throw new RuntimeException("Native library not found in resources: /native/" + libraryName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load tantivy4java native library: " + libraryName, e);
        }
    }

    private static String detectOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (new File("/proc/version").exists()) {
            return "linux";
        }
        if ((System.getenv("KUBERNETES_SERVICE_HOST") != null || System.getenv("container") != null || new File("/.dockerenv").exists()) && (new File("/etc/os-release").exists() || new File("/etc/alpine-release").exists())) {
            return "linux";
        }
        if (osName.contains("windows")) {
            return "windows";
        }
        if (osName.contains("mac") || osName.contains("darwin")) {
            return "darwin";
        }
        return "linux";
    }

    public static native String getVersion();

    public static void initialize() {
    }

    static {
        Tantivy.loadNativeLibrary();
    }
}

