/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.core;

import io.indextables.tantivy4java.core.DocAddress;
import io.indextables.tantivy4java.core.Document;
import io.indextables.tantivy4java.core.Tantivy;
import io.indextables.tantivy4java.query.Order;
import io.indextables.tantivy4java.query.Query;
import io.indextables.tantivy4java.result.SearchResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Searcher
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    Searcher(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public SearchResult search(Query query, int limit, boolean count, String orderByField, int offset, Order order) {
        if (this.closed) {
            throw new IllegalStateException("Searcher has been closed");
        }
        long ptr = Searcher.nativeSearch(this.nativePtr, query.getNativePtr(), limit, count, orderByField, offset, order.getValue());
        return new SearchResult(ptr);
    }

    public SearchResult search(Query query, int limit) {
        return this.search(query, limit, true, null, 0, Order.DESC);
    }

    public SearchResult search(Query query) {
        return this.search(query, 10);
    }

    public Map<String, Object> aggregate(Query searchQuery, Map<String, Object> aggQuery) {
        if (this.closed) {
            throw new IllegalStateException("Searcher has been closed");
        }
        return Searcher.nativeAggregate(this.nativePtr, searchQuery.getNativePtr(), aggQuery);
    }

    public int getNumDocs() {
        if (this.closed) {
            throw new IllegalStateException("Searcher has been closed");
        }
        return Searcher.nativeGetNumDocs(this.nativePtr);
    }

    public int getNumSegments() {
        if (this.closed) {
            throw new IllegalStateException("Searcher has been closed");
        }
        return Searcher.nativeGetNumSegments(this.nativePtr);
    }

    public Document doc(DocAddress docAddress) {
        if (this.closed) {
            throw new IllegalStateException("Searcher has been closed");
        }
        long ptr = Searcher.nativeDoc(this.nativePtr, docAddress.getNativePtr());
        return new Document(ptr);
    }

    public List<Document> docBatch(List<DocAddress> docAddresses) {
        if (this.closed) {
            throw new IllegalStateException("Searcher has been closed");
        }
        if (docAddresses == null || docAddresses.isEmpty()) {
            return new ArrayList<Document>();
        }
        long[] addressPtrs = new long[docAddresses.size()];
        for (int i = 0; i < docAddresses.size(); ++i) {
            addressPtrs[i] = docAddresses.get(i).getNativePtr();
        }
        long[] docPtrs = Searcher.nativeDocBatch(this.nativePtr, addressPtrs);
        ArrayList<Document> documents = new ArrayList<Document>(docPtrs.length);
        for (long ptr : docPtrs) {
            documents.add(new Document(ptr));
        }
        return documents;
    }

    public int docFreq(String fieldName, Object fieldValue) {
        if (this.closed) {
            throw new IllegalStateException("Searcher has been closed");
        }
        return Searcher.nativeDocFreq(this.nativePtr, fieldName, fieldValue);
    }

    public List<String> getSegmentIds() {
        if (this.closed) {
            throw new IllegalStateException("Searcher has been closed");
        }
        return Searcher.nativeGetSegmentIds(this.nativePtr);
    }

    public long getNativePtr() {
        if (this.closed) {
            throw new IllegalStateException("Searcher has been closed");
        }
        return this.nativePtr;
    }

    @Override
    public void close() {
        if (!this.closed) {
            Searcher.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    private static native long nativeSearch(long var0, long var2, int var4, boolean var5, String var6, int var7, int var8);

    private static native Map<String, Object> nativeAggregate(long var0, long var2, Map<String, Object> var4);

    private static native int nativeGetNumDocs(long var0);

    private static native int nativeGetNumSegments(long var0);

    private static native long nativeDoc(long var0, long var2);

    private static native long[] nativeDocBatch(long var0, long[] var2);

    private static native int nativeDocFreq(long var0, String var2, Object var3);

    private static native List<String> nativeGetSegmentIds(long var0);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }
}

