/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.core;

import io.indextables.tantivy4java.core.Schema;
import io.indextables.tantivy4java.core.Tantivy;

public class SchemaBuilder
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    public SchemaBuilder() {
        this.nativePtr = SchemaBuilder.nativeNew();
    }

    SchemaBuilder(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public static boolean isValidFieldName(String name) {
        return SchemaBuilder.nativeIsValidFieldName(name);
    }

    public SchemaBuilder addTextField(String name, boolean stored, boolean fast, String tokenizerName, String indexOption) {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        SchemaBuilder.nativeAddTextField(this.nativePtr, name, stored, fast, tokenizerName, indexOption);
        return this;
    }

    public SchemaBuilder addTextField(String name) {
        return this.addTextField(name, false, false, "default", "position");
    }

    public SchemaBuilder addIntegerField(String name, boolean stored, boolean indexed, boolean fast) {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        SchemaBuilder.nativeAddIntegerField(this.nativePtr, name, stored, indexed, fast);
        return this;
    }

    public SchemaBuilder addIntegerField(String name) {
        return this.addIntegerField(name, false, false, false);
    }

    public SchemaBuilder addFloatField(String name, boolean stored, boolean indexed, boolean fast) {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        SchemaBuilder.nativeAddFloatField(this.nativePtr, name, stored, indexed, fast);
        return this;
    }

    public SchemaBuilder addFloatField(String name) {
        return this.addFloatField(name, false, false, false);
    }

    public SchemaBuilder addUnsignedField(String name, boolean stored, boolean indexed, boolean fast) {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        SchemaBuilder.nativeAddUnsignedField(this.nativePtr, name, stored, indexed, fast);
        return this;
    }

    public SchemaBuilder addUnsignedField(String name) {
        return this.addUnsignedField(name, false, false, false);
    }

    public SchemaBuilder addBooleanField(String name, boolean stored, boolean indexed, boolean fast) {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        SchemaBuilder.nativeAddBooleanField(this.nativePtr, name, stored, indexed, fast);
        return this;
    }

    public SchemaBuilder addBooleanField(String name) {
        return this.addBooleanField(name, false, false, false);
    }

    public SchemaBuilder addDateField(String name, boolean stored, boolean indexed, boolean fast) {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        SchemaBuilder.nativeAddDateField(this.nativePtr, name, stored, indexed, fast);
        return this;
    }

    public SchemaBuilder addDateField(String name) {
        return this.addDateField(name, false, false, false);
    }

    public SchemaBuilder addJsonField(String name, boolean stored, String tokenizerName, String indexOption) {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        SchemaBuilder.nativeAddJsonField(this.nativePtr, name, stored, tokenizerName, indexOption);
        return this;
    }

    public SchemaBuilder addJsonField(String name) {
        return this.addJsonField(name, false, "default", "position");
    }

    public SchemaBuilder addFacetField(String name) {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        SchemaBuilder.nativeAddFacetField(this.nativePtr, name);
        return this;
    }

    public SchemaBuilder addBytesField(String name, boolean stored, boolean indexed, boolean fast, String indexOption) {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        SchemaBuilder.nativeAddBytesField(this.nativePtr, name, stored, indexed, fast, indexOption);
        return this;
    }

    public SchemaBuilder addBytesField(String name) {
        return this.addBytesField(name, false, false, false, "position");
    }

    public SchemaBuilder addIpAddrField(String name, boolean stored, boolean indexed, boolean fast) {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        SchemaBuilder.nativeAddIpAddrField(this.nativePtr, name, stored, indexed, fast);
        return this;
    }

    public SchemaBuilder addIpAddrField(String name) {
        return this.addIpAddrField(name, false, false, false);
    }

    public SchemaBuilder addStringField(String name, boolean stored, boolean indexed, boolean fast) {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        SchemaBuilder.nativeAddStringField(this.nativePtr, name, stored, indexed, fast);
        return this;
    }

    public SchemaBuilder addStringField(String name) {
        return this.addStringField(name, false, false, false);
    }

    public Schema build() {
        if (this.closed) {
            throw new IllegalStateException("SchemaBuilder has been closed");
        }
        long schemaPtr = SchemaBuilder.nativeBuild(this.nativePtr);
        return new Schema(schemaPtr);
    }

    @Override
    public void close() {
        if (!this.closed) {
            SchemaBuilder.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    private static native long nativeNew();

    private static native boolean nativeIsValidFieldName(String var0);

    private static native void nativeAddTextField(long var0, String var2, boolean var3, boolean var4, String var5, String var6);

    private static native void nativeAddIntegerField(long var0, String var2, boolean var3, boolean var4, boolean var5);

    private static native void nativeAddFloatField(long var0, String var2, boolean var3, boolean var4, boolean var5);

    private static native void nativeAddUnsignedField(long var0, String var2, boolean var3, boolean var4, boolean var5);

    private static native void nativeAddBooleanField(long var0, String var2, boolean var3, boolean var4, boolean var5);

    private static native void nativeAddDateField(long var0, String var2, boolean var3, boolean var4, boolean var5);

    private static native void nativeAddJsonField(long var0, String var2, boolean var3, String var4, String var5);

    private static native void nativeAddFacetField(long var0, String var2);

    private static native void nativeAddBytesField(long var0, String var2, boolean var3, boolean var4, boolean var5, String var6);

    private static native void nativeAddIpAddrField(long var0, String var2, boolean var3, boolean var4, boolean var5);

    private static native void nativeAddStringField(long var0, String var2, boolean var3, boolean var4, boolean var5);

    private static native long nativeBuild(long var0);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }
}

