/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.core;

import io.indextables.tantivy4java.core.FieldInfo;
import io.indextables.tantivy4java.core.FieldType;
import io.indextables.tantivy4java.core.Tantivy;
import java.util.List;

public class Schema
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    public Schema(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public long getNativePtr() {
        if (this.closed) {
            throw new IllegalStateException("Schema has been closed");
        }
        return this.nativePtr;
    }

    public List<String> getFieldNames() {
        if (this.closed) {
            throw new IllegalStateException("Schema has been closed");
        }
        return Schema.nativeGetFieldNames(this.nativePtr);
    }

    public FieldInfo getFieldInfo(String fieldName) {
        if (this.closed) {
            throw new IllegalStateException("Schema has been closed");
        }
        return Schema.nativeGetFieldInfo(this.nativePtr, fieldName);
    }

    public List<FieldInfo> getAllFieldInfo() {
        if (this.closed) {
            throw new IllegalStateException("Schema has been closed");
        }
        return Schema.nativeGetAllFieldInfo(this.nativePtr);
    }

    public boolean hasField(String fieldName) {
        if (this.closed) {
            throw new IllegalStateException("Schema has been closed");
        }
        return Schema.nativeHasField(this.nativePtr, fieldName);
    }

    public int getFieldCount() {
        if (this.closed) {
            throw new IllegalStateException("Schema has been closed");
        }
        return Schema.nativeGetFieldCount(this.nativePtr);
    }

    public List<String> getFieldNamesByType(FieldType fieldType) {
        if (this.closed) {
            throw new IllegalStateException("Schema has been closed");
        }
        return Schema.nativeGetFieldNamesByType(this.nativePtr, fieldType.getValue());
    }

    public List<String> getFieldNamesByCapabilities(Boolean stored, Boolean indexed, Boolean fast) {
        if (this.closed) {
            throw new IllegalStateException("Schema has been closed");
        }
        return Schema.nativeGetFieldNamesByCapabilities(this.nativePtr, stored == null ? -1 : (stored != false ? 1 : 0), indexed == null ? -1 : (indexed != false ? 1 : 0), fast == null ? -1 : (fast != false ? 1 : 0));
    }

    public List<String> getStoredFieldNames() {
        return this.getFieldNamesByCapabilities(true, null, null);
    }

    public List<String> getIndexedFieldNames() {
        return this.getFieldNamesByCapabilities(null, true, null);
    }

    public List<String> getFastFieldNames() {
        return this.getFieldNamesByCapabilities(null, null, true);
    }

    public String getSchemaSummary() {
        if (this.closed) {
            throw new IllegalStateException("Schema has been closed");
        }
        return Schema.nativeGetSchemaSummary(this.nativePtr);
    }

    public Schema copy() {
        if (this.closed) {
            throw new IllegalStateException("Cannot copy a closed Schema");
        }
        return new Schema(Schema.nativeClone(this.nativePtr));
    }

    @Override
    public void close() {
        if (!this.closed) {
            Schema.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    private static native void nativeClose(long var0);

    private static native List<String> nativeGetFieldNames(long var0);

    private static native FieldInfo nativeGetFieldInfo(long var0, String var2);

    private static native List<FieldInfo> nativeGetAllFieldInfo(long var0);

    private static native boolean nativeHasField(long var0, String var2);

    private static native int nativeGetFieldCount(long var0);

    private static native List<String> nativeGetFieldNamesByType(long var0, int var2);

    private static native List<String> nativeGetFieldNamesByCapabilities(long var0, int var2, int var3, int var4);

    private static native String nativeGetSchemaSummary(long var0);

    private static native long nativeClone(long var0);

    static {
        Tantivy.initialize();
    }
}

