/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.core;

import io.indextables.tantivy4java.batch.BatchDocumentBuilder;
import io.indextables.tantivy4java.core.Document;
import io.indextables.tantivy4java.core.SegmentMeta;
import io.indextables.tantivy4java.core.Tantivy;
import io.indextables.tantivy4java.query.Query;
import java.nio.ByteBuffer;
import java.util.List;

public class IndexWriter
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    IndexWriter(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public long addDocument(Document doc) {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        return IndexWriter.nativeAddDocument(this.nativePtr, doc.getNativePtr());
    }

    public long addJson(String json) {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        return IndexWriter.nativeAddJson(this.nativePtr, json);
    }

    public long[] addDocumentsByBuffer(ByteBuffer buffer) {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer cannot be null");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Buffer must be a direct ByteBuffer for zero-copy operations");
        }
        if (!buffer.hasRemaining()) {
            throw new IllegalArgumentException("Buffer is empty");
        }
        return IndexWriter.nativeAddDocumentsByBuffer(this.nativePtr, buffer);
    }

    public long[] addDocumentsBatch(BatchDocumentBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        if (builder.isEmpty()) {
            throw new IllegalArgumentException("Builder contains no documents");
        }
        ByteBuffer buffer = builder.build();
        return this.addDocumentsByBuffer(buffer);
    }

    public long commit() {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        return IndexWriter.nativeCommit(this.nativePtr);
    }

    public long rollback() {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        return IndexWriter.nativeRollback(this.nativePtr);
    }

    public void garbageCollectFiles() {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        IndexWriter.nativeGarbageCollectFiles(this.nativePtr);
    }

    public void deleteAllDocuments() {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        IndexWriter.nativeDeleteAllDocuments(this.nativePtr);
    }

    public long getCommitOpstamp() {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        return IndexWriter.nativeGetCommitOpstamp(this.nativePtr);
    }

    public long deleteDocuments(String fieldName, Object fieldValue) {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        return IndexWriter.nativeDeleteDocuments(this.nativePtr, fieldName, fieldValue);
    }

    public long deleteDocumentsByTerm(String fieldName, Object fieldValue) {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        return IndexWriter.nativeDeleteDocumentsByTerm(this.nativePtr, fieldName, fieldValue);
    }

    public long deleteDocumentsByQuery(Query query) {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        return IndexWriter.nativeDeleteDocumentsByQuery(this.nativePtr, query.getNativePtr());
    }

    public void waitMergingThreads() {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        IndexWriter.nativeWaitMergingThreads(this.nativePtr);
    }

    public SegmentMeta merge(List<String> segmentIds) {
        if (this.closed) {
            throw new IllegalStateException("IndexWriter has been closed");
        }
        if (segmentIds == null) {
            throw new IllegalArgumentException("Segment IDs list cannot be null");
        }
        if (segmentIds.isEmpty()) {
            throw new IllegalArgumentException("Segment IDs list cannot be empty");
        }
        long segmentMetaPtr = IndexWriter.nativeMerge(this.nativePtr, segmentIds);
        if (segmentMetaPtr == 0L) {
            throw new RuntimeException("Failed to merge segments");
        }
        return new SegmentMeta(segmentMetaPtr);
    }

    @Override
    public void close() {
        if (!this.closed) {
            IndexWriter.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    private static native long nativeAddDocument(long var0, long var2);

    private static native long nativeAddJson(long var0, String var2);

    private static native long[] nativeAddDocumentsByBuffer(long var0, ByteBuffer var2);

    private static native long nativeCommit(long var0);

    private static native long nativeRollback(long var0);

    private static native void nativeGarbageCollectFiles(long var0);

    private static native void nativeDeleteAllDocuments(long var0);

    private static native long nativeGetCommitOpstamp(long var0);

    private static native long nativeDeleteDocuments(long var0, String var2, Object var3);

    private static native long nativeDeleteDocumentsByTerm(long var0, String var2, Object var3);

    private static native long nativeDeleteDocumentsByQuery(long var0, long var2);

    private static native void nativeWaitMergingThreads(long var0);

    private static native long nativeMerge(long var0, List<String> var2);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }
}

