/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.core;

import io.indextables.tantivy4java.config.FileSystemConfig;
import io.indextables.tantivy4java.core.IndexWriter;
import io.indextables.tantivy4java.core.Schema;
import io.indextables.tantivy4java.core.Searcher;
import io.indextables.tantivy4java.core.Tantivy;
import io.indextables.tantivy4java.query.Query;
import io.indextables.tantivy4java.util.TextAnalyzer;
import java.util.List;
import java.util.Map;

public class Index
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;
    private String indexPath;

    public Index(Schema schema, String path, boolean reuse) {
        String resolvedPath = path == null || path.isEmpty() ? path : (FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(path) : path);
        this.nativePtr = Index.nativeNew(schema.getNativePtr(), resolvedPath, reuse);
        this.indexPath = resolvedPath;
    }

    public Index(Schema schema) {
        this(schema, null, true);
    }

    public Index(Schema schema, String path) {
        this(schema, path, true);
    }

    public static Index open(String path) {
        String resolvedPath = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(path) : path;
        long ptr = Index.nativeOpen(resolvedPath);
        Index index = new Index(ptr);
        index.indexPath = resolvedPath;
        return index;
    }

    public static boolean exists(String path) {
        String resolvedPath = FileSystemConfig.hasGlobalRoot() ? FileSystemConfig.resolvePath(path) : path;
        return Index.nativeExists(resolvedPath);
    }

    Index(long nativePtr) {
        this.nativePtr = nativePtr;
        this.indexPath = null;
    }

    public IndexWriter writer(int heapSize, int numThreads) {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        if (heapSize < 15000000) {
            throw new IllegalArgumentException("Heap size must be at least 15000000 bytes (15MB). Consider using Index.Memory.DEFAULT_HEAP_SIZE (50000000) or other predefined constants.");
        }
        long ptr = Index.nativeWriter(this.nativePtr, heapSize, numThreads);
        return new IndexWriter(ptr);
    }

    public IndexWriter writer() {
        return this.writer(128000000, 0);
    }

    public void configReader(String reloadPolicy, int numWarmers) {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        Index.nativeConfigReader(this.nativePtr, reloadPolicy, numWarmers);
    }

    public void configReader() {
        this.configReader("commit", 0);
    }

    public Searcher searcher() {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        long ptr = Index.nativeSearcher(this.nativePtr);
        return new Searcher(ptr);
    }

    public Schema getSchema() {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        long ptr = Index.nativeGetSchema(this.nativePtr);
        return new Schema(ptr);
    }

    public void reload() {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        Index.nativeReload(this.nativePtr);
    }

    public Query parseQuery(String query, List<String> defaultFieldNames, Map<String, Double> fieldBoosts, Map<String, FuzzyConfig> fuzzyFields) {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        long ptr = Index.nativeParseQuery(this.nativePtr, query, defaultFieldNames, fieldBoosts, fuzzyFields);
        return new Query(ptr);
    }

    public Query parseQuery(String query, List<String> defaultFieldNames) {
        return this.parseQuery(query, defaultFieldNames, null, null);
    }

    public Query parseQuery(String queryString) {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        if (queryString == null || queryString.trim().isEmpty()) {
            throw new IllegalArgumentException("Query string cannot be null or empty");
        }
        long queryPtr = Index.nativeParseQuerySimple(this.nativePtr, queryString);
        if (queryPtr == 0L) {
            throw new RuntimeException("Failed to parse query: " + queryString);
        }
        return new Query(queryPtr);
    }

    public ParseResult parseQueryLenient(String query, List<String> defaultFieldNames, Map<String, Double> fieldBoosts, Map<String, FuzzyConfig> fuzzyFields) {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        long ptr = Index.nativeParseQueryLenient(this.nativePtr, query, defaultFieldNames, fieldBoosts, fuzzyFields);
        return new ParseResult(ptr);
    }

    public ParseResult parseQueryLenient(String query, List<String> defaultFieldNames) {
        return this.parseQueryLenient(query, defaultFieldNames, null, null);
    }

    public void registerTokenizer(String name, TextAnalyzer textAnalyzer) {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        Index.nativeRegisterTokenizer(this.nativePtr, name, textAnalyzer.getNativePtr());
    }

    public long getNativePtr() {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        return this.nativePtr;
    }

    public String getIndexPath() {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        return this.indexPath;
    }

    @Override
    public void close() {
        if (!this.closed) {
            Index.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    public Object createSplitGenerator(int targetDocsPerSplit) {
        if (this.closed) {
            throw new IllegalStateException("Index has been closed");
        }
        try {
            Class<?> generatorClass = Class.forName("com.tantivy4java.splits.QuickwitSplitGenerator");
            return generatorClass.getConstructor(Index.class, Integer.TYPE).newInstance(this, targetDocsPerSplit);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("QuickwitSplitGenerator not available. Add quickwit-splits4java dependency.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create QuickwitSplitGenerator", e);
        }
    }

    private static native long nativeNew(long var0, String var2, boolean var3);

    private static native long nativeOpen(String var0);

    private static native boolean nativeExists(String var0);

    private static native long nativeWriter(long var0, int var2, int var3);

    private static native void nativeConfigReader(long var0, String var2, int var3);

    private static native long nativeSearcher(long var0);

    private static native long nativeGetSchema(long var0);

    private static native void nativeReload(long var0);

    private static native long nativeParseQuery(long var0, String var2, List<String> var3, Map<String, Double> var4, Map<String, FuzzyConfig> var5);

    private static native long nativeParseQuerySimple(long var0, String var2);

    private static native long nativeParseQueryLenient(long var0, String var2, List<String> var3, Map<String, Double> var4, Map<String, FuzzyConfig> var5);

    private static native void nativeRegisterTokenizer(long var0, String var2, long var3);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }

    public static class ParseResult
    implements AutoCloseable {
        private long nativePtr;
        private boolean closed = false;

        ParseResult(long nativePtr) {
            this.nativePtr = nativePtr;
        }

        public Query getQuery() {
            if (this.closed) {
                throw new IllegalStateException("ParseResult has been closed");
            }
            long ptr = ParseResult.nativeGetQuery(this.nativePtr);
            return new Query(ptr);
        }

        public List<String> getErrors() {
            if (this.closed) {
                throw new IllegalStateException("ParseResult has been closed");
            }
            return ParseResult.nativeGetErrors(this.nativePtr);
        }

        @Override
        public void close() {
            if (!this.closed) {
                ParseResult.nativeCloseParseResult(this.nativePtr);
                this.closed = true;
                this.nativePtr = 0L;
            }
        }

        private static native long nativeGetQuery(long var0);

        private static native List<String> nativeGetErrors(long var0);

        private static native void nativeCloseParseResult(long var0);
    }

    public static class FuzzyConfig {
        private final boolean prefix;
        private final int distance;
        private final boolean transpositionCostOne;

        public FuzzyConfig(boolean prefix, int distance, boolean transpositionCostOne) {
            this.prefix = prefix;
            this.distance = distance;
            this.transpositionCostOne = transpositionCostOne;
        }

        public boolean isPrefix() {
            return this.prefix;
        }

        public int getDistance() {
            return this.distance;
        }

        public boolean isTranspositionCostOne() {
            return this.transpositionCostOne;
        }
    }

    public static final class Memory {
        public static final int MIN_HEAP_SIZE = 15000000;
        public static final int DEFAULT_HEAP_SIZE = 50000000;
        public static final int LARGE_HEAP_SIZE = 128000000;
        public static final int XL_HEAP_SIZE = 256000000;

        private Memory() {
        }
    }
}

