/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.core;

import io.indextables.tantivy4java.core.FieldType;
import java.util.Objects;

public class FieldInfo {
    private final String name;
    private final FieldType type;
    private final boolean stored;
    private final boolean indexed;
    private final boolean fast;
    private final String tokenizerName;
    private final String indexOption;

    public FieldInfo(String name, FieldType type, boolean stored, boolean indexed, boolean fast, String tokenizerName, String indexOption) {
        this.name = Objects.requireNonNull(name, "Field name cannot be null");
        this.type = Objects.requireNonNull(type, "Field type cannot be null");
        this.stored = stored;
        this.indexed = indexed;
        this.fast = fast;
        this.tokenizerName = tokenizerName;
        this.indexOption = indexOption;
    }

    public FieldInfo(String name, FieldType type, boolean stored, boolean indexed, boolean fast) {
        this(name, type, stored, indexed, fast, null, null);
    }

    public String getName() {
        return this.name;
    }

    public FieldType getType() {
        return this.type;
    }

    public boolean isStored() {
        return this.stored;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public boolean isFast() {
        return this.fast;
    }

    public String getTokenizerName() {
        return this.tokenizerName;
    }

    public String getIndexOption() {
        return this.indexOption;
    }

    public boolean isTextfield() {
        return this.type == FieldType.TEXT;
    }

    public boolean isNumeric() {
        return this.type == FieldType.INTEGER || this.type == FieldType.UNSIGNED || this.type == FieldType.FLOAT;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldInfo fieldInfo = (FieldInfo)obj;
        return this.stored == fieldInfo.stored && this.indexed == fieldInfo.indexed && this.fast == fieldInfo.fast && Objects.equals(this.name, fieldInfo.name) && this.type == fieldInfo.type && Objects.equals(this.tokenizerName, fieldInfo.tokenizerName) && Objects.equals(this.indexOption, fieldInfo.indexOption);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.stored, this.indexed, this.fast, this.tokenizerName, this.indexOption});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FieldInfo{name='").append(this.name).append("', type=").append((Object)this.type);
        sb.append(", stored=").append(this.stored).append(", indexed=").append(this.indexed);
        sb.append(", fast=").append(this.fast);
        if (this.tokenizerName != null) {
            sb.append(", tokenizer='").append(this.tokenizerName).append("'");
        }
        if (this.indexOption != null) {
            sb.append(", indexOption='").append(this.indexOption).append("'");
        }
        sb.append("}");
        return sb.toString();
    }
}

