/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.core;

import io.indextables.tantivy4java.core.Schema;
import io.indextables.tantivy4java.core.Tantivy;
import io.indextables.tantivy4java.util.Facet;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

public class Document
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    public Document() {
        this.nativePtr = Document.nativeNew();
    }

    public static Document fromMap(Map<String, Object> fields, Schema schema) {
        long ptr = Document.nativeFromMap(fields, schema != null ? schema.getNativePtr() : 0L);
        return new Document(ptr);
    }

    public static Document fromMap(Map<String, Object> fields) {
        return Document.fromMap(fields, null);
    }

    public Document(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public List<Object> get(String fieldName) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        return Document.nativeGet(this.nativePtr, fieldName);
    }

    public Object getFirst(String fieldName) {
        List<Object> values = this.get(fieldName);
        return values.isEmpty() ? null : values.get(0);
    }

    public Map<String, List<Object>> toMap() {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        return Document.nativeToMap(this.nativePtr);
    }

    public void extend(Map<String, Object> fields, Schema schema) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        Document.nativeExtend(this.nativePtr, fields, schema != null ? schema.getNativePtr() : 0L);
    }

    public void extend(Map<String, Object> fields) {
        this.extend(fields, null);
    }

    public void addText(String fieldName, String text) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        Document.nativeAddText(this.nativePtr, fieldName, text);
    }

    public void addUnsigned(String fieldName, long value) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        Document.nativeAddUnsigned(this.nativePtr, fieldName, value);
    }

    public void addInteger(String fieldName, long value) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        Document.nativeAddInteger(this.nativePtr, fieldName, value);
    }

    public void addFloat(String fieldName, double value) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        Document.nativeAddFloat(this.nativePtr, fieldName, value);
    }

    public void addBoolean(String fieldName, boolean value) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        Document.nativeAddBoolean(this.nativePtr, fieldName, value);
    }

    public void addDate(String fieldName, LocalDateTime date) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        Document.nativeAddDate(this.nativePtr, fieldName, date);
    }

    public void addFacet(String fieldName, Facet facet) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        Document.nativeAddFacet(this.nativePtr, fieldName, facet.getNativePtr());
    }

    public void addBytes(String fieldName, byte[] bytes) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        Document.nativeAddBytes(this.nativePtr, fieldName, bytes);
    }

    public void addJson(String fieldName, Object value) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        String jsonString = this.convertToJsonString(value);
        Document.nativeAddJson(this.nativePtr, fieldName, jsonString);
    }

    private String convertToJsonString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + ((String)value).replace("\"", "\\\"") + "\"";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            StringBuilder json = new StringBuilder("{");
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (!first) {
                    json.append(",");
                }
                first = false;
                json.append("\"").append((String)entry.getKey()).append("\":");
                json.append(this.convertToJsonString(entry.getValue()));
            }
            json.append("}");
            return json.toString();
        }
        return "\"" + value.toString().replace("\"", "\\\"") + "\"";
    }

    public void addIpAddr(String fieldName, String ipAddr) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        Document.nativeAddIpAddr(this.nativePtr, fieldName, ipAddr);
    }

    public void addString(String fieldName, String value) {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        Document.nativeAddString(this.nativePtr, fieldName, value);
    }

    public int getNumFields() {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        return Document.nativeGetNumFields(this.nativePtr);
    }

    public boolean isEmpty() {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        return Document.nativeIsEmpty(this.nativePtr);
    }

    public List<Object> getAll(String fieldName) {
        return this.get(fieldName);
    }

    public long getNativePtr() {
        if (this.closed) {
            throw new IllegalStateException("Document has been closed");
        }
        return this.nativePtr;
    }

    @Override
    public void close() {
        if (!this.closed) {
            Document.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    private static native long nativeNew();

    private static native long nativeFromMap(Map<String, Object> var0, long var1);

    private static native List<Object> nativeGet(long var0, String var2);

    private static native Map<String, List<Object>> nativeToMap(long var0);

    private static native void nativeExtend(long var0, Map<String, Object> var2, long var3);

    private static native void nativeAddText(long var0, String var2, String var3);

    private static native void nativeAddUnsigned(long var0, String var2, long var3);

    private static native void nativeAddInteger(long var0, String var2, long var3);

    private static native void nativeAddFloat(long var0, String var2, double var3);

    private static native void nativeAddBoolean(long var0, String var2, boolean var3);

    private static native void nativeAddDate(long var0, String var2, LocalDateTime var3);

    private static native void nativeAddFacet(long var0, String var2, long var3);

    private static native void nativeAddBytes(long var0, String var2, byte[] var3);

    private static native void nativeAddJson(long var0, String var2, String var3);

    private static native void nativeAddIpAddr(long var0, String var2, String var3);

    private static native void nativeAddString(long var0, String var2, String var3);

    private static native int nativeGetNumFields(long var0);

    private static native boolean nativeIsEmpty(long var0);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }
}

