/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.core;

import io.indextables.tantivy4java.core.Tantivy;

public class DocAddress
implements AutoCloseable {
    private long nativePtr;
    private boolean closed = false;

    public DocAddress(int segmentOrd, int doc) {
        this.nativePtr = DocAddress.nativeNew(segmentOrd, doc);
    }

    DocAddress(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public int getSegmentOrd() {
        if (this.closed) {
            throw new IllegalStateException("DocAddress has been closed");
        }
        return DocAddress.nativeGetSegmentOrd(this.nativePtr);
    }

    public int getDoc() {
        if (this.closed) {
            throw new IllegalStateException("DocAddress has been closed");
        }
        return DocAddress.nativeGetDoc(this.nativePtr);
    }

    public long getNativePtr() {
        if (this.closed) {
            throw new IllegalStateException("DocAddress has been closed");
        }
        return this.nativePtr;
    }

    @Override
    public void close() {
        if (!this.closed) {
            DocAddress.nativeClose(this.nativePtr);
            this.closed = true;
            this.nativePtr = 0L;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DocAddress that = (DocAddress)obj;
        return this.getSegmentOrd() == that.getSegmentOrd() && this.getDoc() == that.getDoc();
    }

    public int hashCode() {
        return 31 * this.getSegmentOrd() + this.getDoc();
    }

    public String toString() {
        return String.format("DocAddress{segmentOrd=%d, doc=%d}", this.getSegmentOrd(), this.getDoc());
    }

    private static native long nativeNew(int var0, int var1);

    private static native int nativeGetSegmentOrd(long var0);

    private static native int nativeGetDoc(long var0);

    private static native void nativeClose(long var0);

    static {
        Tantivy.initialize();
    }
}

