/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.config;

import io.indextables.tantivy4java.split.SplitCacheManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GlobalCacheUtils {
    public static GlobalCacheFlushStats flushAllCaches() {
        Map<String, SplitCacheManager> allInstances = SplitCacheManager.getAllInstances();
        ArrayList<SplitCacheManager.CacheFlushStats> individualStats = new ArrayList<SplitCacheManager.CacheFlushStats>();
        for (SplitCacheManager manager : allInstances.values()) {
            try {
                SplitCacheManager.CacheFlushStats stats = manager.flushAllCaches();
                individualStats.add(stats);
            }
            catch (Exception e) {
                System.err.println("Warning: Failed to flush cache manager '" + manager.getCacheName() + "': " + e.getMessage());
            }
        }
        return new GlobalCacheFlushStats(individualStats);
    }

    public static void flushCacheTypes(Set<SplitCacheManager.CacheType> cacheTypes) {
        Map<String, SplitCacheManager> allInstances = SplitCacheManager.getAllInstances();
        for (SplitCacheManager manager : allInstances.values()) {
            try {
                manager.flushCacheTypes(cacheTypes);
            }
            catch (Exception e) {
                System.err.println("Warning: Failed to flush cache types for manager '" + manager.getCacheName() + "': " + e.getMessage());
            }
        }
    }

    public static GlobalSystemCacheStats getSystemCacheStats() {
        Map<String, SplitCacheManager> allInstances = SplitCacheManager.getAllInstances();
        HashMap<String, SplitCacheManager.GlobalCacheStats> managerStats = new HashMap<String, SplitCacheManager.GlobalCacheStats>();
        for (Map.Entry<String, SplitCacheManager> entry : allInstances.entrySet()) {
            try {
                managerStats.put(entry.getKey(), entry.getValue().getGlobalCacheStats());
            }
            catch (Exception e) {
                System.err.println("Warning: Failed to get stats for cache manager '" + entry.getKey() + "': " + e.getMessage());
            }
        }
        return new GlobalSystemCacheStats(managerStats);
    }

    public static List<String> getActiveCacheManagerNames() {
        return new ArrayList<String>(SplitCacheManager.getAllInstances().keySet());
    }

    public static class GlobalSystemCacheStats {
        private final Map<String, SplitCacheManager.GlobalCacheStats> managerStats;
        private final long totalSizeBytes;
        private final long totalHits;
        private final long totalMisses;
        private final int activeCacheManagers;

        public GlobalSystemCacheStats(Map<String, SplitCacheManager.GlobalCacheStats> managerStats) {
            this.managerStats = new HashMap<String, SplitCacheManager.GlobalCacheStats>(managerStats);
            this.activeCacheManagers = managerStats.size();
            this.totalSizeBytes = managerStats.values().stream().mapToLong(SplitCacheManager.GlobalCacheStats::getCurrentSize).sum();
            this.totalHits = managerStats.values().stream().mapToLong(SplitCacheManager.GlobalCacheStats::getTotalHits).sum();
            this.totalMisses = managerStats.values().stream().mapToLong(SplitCacheManager.GlobalCacheStats::getTotalMisses).sum();
        }

        public long getTotalSizeBytes() {
            return this.totalSizeBytes;
        }

        public long getTotalHits() {
            return this.totalHits;
        }

        public long getTotalMisses() {
            return this.totalMisses;
        }

        public int getActiveCacheManagers() {
            return this.activeCacheManagers;
        }

        public double getOverallHitRate() {
            long totalRequests = this.totalHits + this.totalMisses;
            return totalRequests > 0L ? (double)this.totalHits / (double)totalRequests : 0.0;
        }

        public Map<String, SplitCacheManager.GlobalCacheStats> getManagerStats() {
            return new HashMap<String, SplitCacheManager.GlobalCacheStats>(this.managerStats);
        }

        public String toString() {
            return String.format("GlobalSystemCacheStats{totalSizeBytes=%d, totalHits=%d, totalMisses=%d, hitRate=%.2f%%, activeCacheManagers=%d}", this.totalSizeBytes, this.totalHits, this.totalMisses, this.getOverallHitRate() * 100.0, this.activeCacheManagers);
        }
    }

    public static class GlobalCacheFlushStats {
        private final List<SplitCacheManager.CacheFlushStats> individualStats;
        private final long totalBytesFreed;
        private final long totalItemsEvicted;
        private final int cacheManagersAffected;
        private final int totalSplitsAffected;

        public GlobalCacheFlushStats(List<SplitCacheManager.CacheFlushStats> individualStats) {
            this.individualStats = new ArrayList<SplitCacheManager.CacheFlushStats>(individualStats);
            this.cacheManagersAffected = individualStats.size();
            this.totalBytesFreed = individualStats.stream().mapToLong(SplitCacheManager.CacheFlushStats::getBytesFreed).sum();
            this.totalItemsEvicted = individualStats.stream().mapToLong(SplitCacheManager.CacheFlushStats::getItemsEvicted).sum();
            this.totalSplitsAffected = individualStats.stream().mapToInt(SplitCacheManager.CacheFlushStats::getSplitsAffected).sum();
        }

        public long getTotalBytesFreed() {
            return this.totalBytesFreed;
        }

        public long getTotalItemsEvicted() {
            return this.totalItemsEvicted;
        }

        public int getCacheManagersAffected() {
            return this.cacheManagersAffected;
        }

        public int getTotalSplitsAffected() {
            return this.totalSplitsAffected;
        }

        public List<SplitCacheManager.CacheFlushStats> getIndividualStats() {
            return new ArrayList<SplitCacheManager.CacheFlushStats>(this.individualStats);
        }

        public String toString() {
            return String.format("GlobalCacheFlushStats{totalBytesFreed=%d, totalItemsEvicted=%d, cacheManagersAffected=%d, totalSplitsAffected=%d}", this.totalBytesFreed, this.totalItemsEvicted, this.cacheManagersAffected, this.totalSplitsAffected);
        }
    }
}

