/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.config;

public class GlobalCacheConfig {
    private long fastFieldCacheMB = 1024L;
    private long splitFooterCacheMB = 500L;
    private long partialRequestCacheMB = 64L;
    private int maxConcurrentSplits = 100;
    private long aggregationMemoryMB = 500L;
    private int aggregationBucketLimit = 65000;
    private long warmupMemoryGB = 100L;
    private long splitCacheGB = 10L;
    private int splitCacheMaxSplits = 10000;
    private String splitCachePath = null;
    private static boolean initialized = false;

    public GlobalCacheConfig withFastFieldCacheMB(long mb) {
        this.fastFieldCacheMB = mb;
        return this;
    }

    public GlobalCacheConfig withSplitFooterCacheMB(long mb) {
        this.splitFooterCacheMB = mb;
        return this;
    }

    public GlobalCacheConfig withPartialRequestCacheMB(long mb) {
        this.partialRequestCacheMB = mb;
        return this;
    }

    public GlobalCacheConfig withMaxConcurrentSplits(int max) {
        this.maxConcurrentSplits = max;
        return this;
    }

    public GlobalCacheConfig withAggregationMemoryMB(long mb) {
        this.aggregationMemoryMB = mb;
        return this;
    }

    public GlobalCacheConfig withAggregationBucketLimit(int limit) {
        this.aggregationBucketLimit = limit;
        return this;
    }

    public GlobalCacheConfig withWarmupMemoryGB(long gb) {
        this.warmupMemoryGB = gb;
        return this;
    }

    public GlobalCacheConfig withSplitCacheGB(long gb) {
        this.splitCacheGB = gb;
        return this;
    }

    public GlobalCacheConfig withSplitCacheMaxSplits(int max) {
        this.splitCacheMaxSplits = max;
        return this;
    }

    public GlobalCacheConfig withSplitCachePath(String path) {
        this.splitCachePath = path;
        return this;
    }

    public synchronized boolean initialize() {
        if (initialized) {
            return false;
        }
        boolean success = GlobalCacheConfig.initializeGlobalCache(this.fastFieldCacheMB, this.splitFooterCacheMB, this.partialRequestCacheMB, this.maxConcurrentSplits, this.aggregationMemoryMB, this.aggregationBucketLimit, this.warmupMemoryGB, this.splitCacheGB, this.splitCacheMaxSplits, this.splitCachePath);
        if (success) {
            initialized = true;
        }
        return success;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    private static native boolean initializeGlobalCache(long var0, long var2, long var4, int var6, long var7, int var9, long var10, long var12, int var14, String var15);

    static {
        System.loadLibrary("tantivy4java");
    }
}

