/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.config;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;

public class FileSystemConfig {
    private static final AtomicReference<String> globalFileSystemRoot = new AtomicReference<Object>(null);

    public static void setGlobalRoot(String rootPath) {
        if (rootPath == null) {
            globalFileSystemRoot.set(null);
            return;
        }
        Path normalizedPath = Paths.get(rootPath, new String[0]).toAbsolutePath().normalize();
        File rootDir = normalizedPath.toFile();
        if (!rootDir.exists()) {
            throw new IllegalArgumentException("File system root does not exist: " + String.valueOf(normalizedPath));
        }
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("File system root is not a directory: " + String.valueOf(normalizedPath));
        }
        if (!rootDir.canRead() || !rootDir.canWrite()) {
            throw new IllegalArgumentException("File system root is not readable/writable: " + String.valueOf(normalizedPath));
        }
        globalFileSystemRoot.set(normalizedPath.toString());
    }

    public static void clearGlobalRoot() {
        globalFileSystemRoot.set(null);
    }

    public static String getGlobalRoot() {
        return globalFileSystemRoot.get();
    }

    public static boolean hasGlobalRoot() {
        return globalFileSystemRoot.get() != null;
    }

    public static String resolvePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        String root = globalFileSystemRoot.get();
        if (root == null) {
            return path;
        }
        Path rootPath = Paths.get(root, new String[0]);
        Path targetPath = Paths.get(path, new String[0]);
        if (!targetPath.isAbsolute()) {
            return rootPath.resolve(targetPath).normalize().toString();
        }
        Path normalizedTarget = targetPath.normalize();
        if (!normalizedTarget.startsWith(rootPath)) {
            throw new IllegalArgumentException("Absolute path is outside configured root. Path: " + path + ", Root: " + root);
        }
        return normalizedTarget.toString();
    }

    public static void validatePath(String path) {
        FileSystemConfig.resolvePath(path);
    }

    public static String makeRelative(String absolutePath) {
        String root = globalFileSystemRoot.get();
        if (root == null) {
            throw new IllegalArgumentException("No file system root configured");
        }
        Path rootPath = Paths.get(root, new String[0]);
        Path targetPath = Paths.get(absolutePath, new String[0]).normalize();
        if (!targetPath.startsWith(rootPath)) {
            throw new IllegalArgumentException("Path is outside configured root. Path: " + absolutePath + ", Root: " + root);
        }
        return rootPath.relativize(targetPath).toString();
    }

    public static String getConfigSummary() {
        String root = globalFileSystemRoot.get();
        if (root == null) {
            return "FileSystemConfig: No root configured (system default behavior)";
        }
        return "FileSystemConfig: Root = " + root;
    }
}

