/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.batch;

import io.indextables.tantivy4java.util.Facet;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BatchDocument {
    private final Map<String, List<FieldValue>> fields = new HashMap<String, List<FieldValue>>();

    public static BatchDocument fromMap(Map<String, Object> fields) {
        BatchDocument doc = new BatchDocument();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            String fieldName = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                List values = (List)value;
                for (Object val : values) {
                    doc.addValue(fieldName, val);
                }
                continue;
            }
            doc.addValue(fieldName, value);
        }
        return doc;
    }

    private void addValue(String fieldName, Object value) {
        if (value instanceof String) {
            this.addText(fieldName, (String)value);
        } else if (value instanceof Long) {
            this.addInteger(fieldName, (Long)value);
        } else if (value instanceof Integer) {
            this.addInteger(fieldName, ((Integer)value).longValue());
        } else if (value instanceof Double) {
            this.addFloat(fieldName, (Double)value);
        } else if (value instanceof Float) {
            this.addFloat(fieldName, ((Float)value).doubleValue());
        } else if (value instanceof Boolean) {
            this.addBoolean(fieldName, (Boolean)value);
        } else if (value instanceof LocalDateTime) {
            this.addDate(fieldName, (LocalDateTime)value);
        } else if (value instanceof byte[]) {
            this.addBytes(fieldName, (byte[])value);
        } else if (value instanceof Facet) {
            this.addFacet(fieldName, (Facet)value);
        } else {
            this.addJson(fieldName, value);
        }
    }

    public void addText(String fieldName, String text) {
        this.addFieldValue(fieldName, FieldType.TEXT, text);
    }

    public void addUnsigned(String fieldName, long value) {
        this.addFieldValue(fieldName, FieldType.UNSIGNED, value);
    }

    public void addInteger(String fieldName, long value) {
        this.addFieldValue(fieldName, FieldType.INTEGER, value);
    }

    public void addFloat(String fieldName, double value) {
        this.addFieldValue(fieldName, FieldType.FLOAT, value);
    }

    public void addBoolean(String fieldName, boolean value) {
        this.addFieldValue(fieldName, FieldType.BOOLEAN, value);
    }

    public void addDate(String fieldName, LocalDateTime date) {
        this.addFieldValue(fieldName, FieldType.DATE, date);
    }

    public void addFacet(String fieldName, Facet facet) {
        this.addFieldValue(fieldName, FieldType.FACET, facet);
    }

    public void addBytes(String fieldName, byte[] bytes) {
        this.addFieldValue(fieldName, FieldType.BYTES, bytes);
    }

    public void addJson(String fieldName, Object value) {
        this.addFieldValue(fieldName, FieldType.JSON, value);
    }

    public void addIpAddr(String fieldName, String ipAddr) {
        this.addFieldValue(fieldName, FieldType.IP_ADDR, ipAddr);
    }

    private void addFieldValue(String fieldName, FieldType type, Object value) {
        this.fields.computeIfAbsent(fieldName, k -> new ArrayList()).add(new FieldValue(type, value));
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    List<FieldValue> getFieldValues(String fieldName) {
        return this.fields.getOrDefault(fieldName, new ArrayList());
    }

    Map<String, List<FieldValue>> getAllFields() {
        return this.fields;
    }

    static class FieldValue {
        private final FieldType type;
        private final Object value;

        public FieldValue(FieldType type, Object value) {
            this.type = type;
            this.value = value;
        }

        public FieldType getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }

    static enum FieldType {
        TEXT(0),
        INTEGER(1),
        FLOAT(2),
        BOOLEAN(3),
        DATE(4),
        BYTES(5),
        JSON(6),
        IP_ADDR(7),
        UNSIGNED(8),
        FACET(9);

        private final byte code;

        private FieldType(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static FieldType fromCode(byte code) {
            for (FieldType type : FieldType.values()) {
                if (type.code != code) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown field type code: " + code);
        }
    }
}

