/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.aggregation.AggregationResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TermsResult
implements AggregationResult {
    private final String name;
    private final List<TermsBucket> buckets;
    private final long docCountErrorUpperBound;
    private final long sumOtherDocCount;

    public TermsResult(String name, List<TermsBucket> buckets, long docCountErrorUpperBound, long sumOtherDocCount) {
        this.name = name;
        this.buckets = buckets;
        this.docCountErrorUpperBound = docCountErrorUpperBound;
        this.sumOtherDocCount = sumOtherDocCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return "terms";
    }

    public List<TermsBucket> getBuckets() {
        return this.buckets;
    }

    public long getDocCountErrorUpperBound() {
        return this.docCountErrorUpperBound;
    }

    public long getSumOtherDocCount() {
        return this.sumOtherDocCount;
    }

    public String toString() {
        return String.format("TermsResult{name='%s', buckets=%d, errorBound=%d, otherDocs=%d}", this.name, this.buckets.size(), this.docCountErrorUpperBound, this.sumOtherDocCount);
    }

    public static class TermsBucket {
        private final Object key;
        private final long docCount;
        private final Map<String, AggregationResult> subAggregations;

        public TermsBucket(Object key, long docCount) {
            this.key = key;
            this.docCount = docCount;
            this.subAggregations = new HashMap<String, AggregationResult>();
        }

        public TermsBucket(Object key, long docCount, Map<String, AggregationResult> subAggregations) {
            this.key = key;
            this.docCount = docCount;
            this.subAggregations = subAggregations != null ? subAggregations : new HashMap();
        }

        public Object getKey() {
            return this.key;
        }

        public String getKeyAsString() {
            return this.key != null ? this.key.toString() : null;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public AggregationResult getSubAggregation(String name) {
            return this.subAggregations.get(name);
        }

        public Map<String, AggregationResult> getSubAggregations() {
            return this.subAggregations;
        }

        public boolean hasSubAggregations() {
            return !this.subAggregations.isEmpty();
        }

        public String toString() {
            if (this.hasSubAggregations()) {
                return String.format("TermsBucket{key='%s', docCount=%d, subAggs=%s}", this.key, this.docCount, this.subAggregations.keySet());
            }
            return String.format("TermsBucket{key='%s', docCount=%d}", this.key, this.docCount);
        }
    }
}

