/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.split.SplitAggregation;
import java.util.HashMap;
import java.util.Map;

public class TermsAggregation
extends SplitAggregation {
    private final String fieldName;
    private final int size;
    private final int shardSize;
    private final Map<String, SplitAggregation> subAggregations;

    public TermsAggregation(String fieldName) {
        this("terms_" + fieldName, fieldName, 10, 0);
    }

    public TermsAggregation(String fieldName, int size) {
        this("terms_" + fieldName, fieldName, size, 0);
    }

    public TermsAggregation(String name, String fieldName, int size, int shardSize) {
        super(name);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive");
        }
        this.fieldName = fieldName.trim();
        this.size = size;
        this.shardSize = shardSize;
        this.subAggregations = new HashMap<String, SplitAggregation>();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getAggregationType() {
        return "terms";
    }

    @Override
    public String toAggregationJson() {
        StringBuilder json = new StringBuilder();
        json.append("{\"terms\": {\"field\": \"").append(this.fieldName).append("\"");
        json.append(", \"size\": ").append(this.size);
        if (this.shardSize > 0) {
            json.append(", \"shard_size\": ").append(this.shardSize);
        }
        json.append("}");
        if (!this.subAggregations.isEmpty()) {
            json.append(", \"aggs\": {");
            boolean first = true;
            for (Map.Entry<String, SplitAggregation> entry : this.subAggregations.entrySet()) {
                if (!first) {
                    json.append(", ");
                }
                json.append("\"").append(entry.getKey()).append("\": ");
                json.append(entry.getValue().toAggregationJson());
                first = false;
            }
            json.append("}");
        }
        json.append("}");
        return json.toString();
    }

    public int getSize() {
        return this.size;
    }

    public int getShardSize() {
        return this.shardSize;
    }

    public TermsAggregation addSubAggregation(String name, SplitAggregation aggregation) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Sub-aggregation name cannot be null or empty");
        }
        if (aggregation == null) {
            throw new IllegalArgumentException("Sub-aggregation cannot be null");
        }
        this.subAggregations.put(name.trim(), aggregation);
        return this;
    }

    public Map<String, SplitAggregation> getSubAggregations() {
        return this.subAggregations;
    }

    public boolean hasSubAggregations() {
        return !this.subAggregations.isEmpty();
    }

    public String toString() {
        if (this.hasSubAggregations()) {
            return String.format("TermsAggregation{name='%s', field='%s', size=%d, shardSize=%d, subAggs=%s}", this.name, this.fieldName, this.size, this.shardSize, this.subAggregations.keySet());
        }
        return String.format("TermsAggregation{name='%s', field='%s', size=%d, shardSize=%d}", this.name, this.fieldName, this.size, this.shardSize);
    }
}

