/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.aggregation.AggregationResult;

public class StatsResult
implements AggregationResult {
    private final String name;
    private final long count;
    private final double sum;
    private final double min;
    private final double max;

    public StatsResult(String name, long count, double sum, double min, double max) {
        this.name = name;
        this.count = count;
        this.sum = sum;
        this.min = min;
        this.max = max;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return "stats";
    }

    public long getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getAverage() {
        return this.count > 0L ? this.sum / (double)this.count : 0.0;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public String toString() {
        return String.format("StatsResult{name='%s', count=%d, sum=%.2f, avg=%.2f, min=%.2f, max=%.2f}", this.name, this.count, this.sum, this.getAverage(), this.min, this.max);
    }
}

