/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.split.SplitAggregation;

public class StatsAggregation
extends SplitAggregation {
    private final String fieldName;

    public StatsAggregation(String fieldName) {
        super("stats_" + fieldName);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
    }

    public StatsAggregation(String name, String fieldName) {
        super(name);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getAggregationType() {
        return "stats";
    }

    @Override
    public String toAggregationJson() {
        return String.format("{\"stats\": {\"field\": \"%s\"}}", this.fieldName);
    }

    public String toString() {
        return String.format("StatsAggregation{name='%s', field='%s'}", this.name, this.fieldName);
    }
}

