/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.aggregation.AggregationResult;
import java.util.List;

public class RangeResult
implements AggregationResult {
    private final String name;
    private final List<RangeBucket> buckets;

    public RangeResult(String name, List<RangeBucket> buckets) {
        this.name = name;
        this.buckets = buckets;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return "range";
    }

    public List<RangeBucket> getBuckets() {
        return this.buckets;
    }

    public String toString() {
        return String.format("RangeResult{name='%s', buckets=%d}", this.name, this.buckets.size());
    }

    public static class RangeBucket {
        private final String key;
        private final Double from;
        private final Double to;
        private final long docCount;

        public RangeBucket(String key, Double from, Double to, long docCount) {
            this.key = key;
            this.from = from;
            this.to = to;
            this.docCount = docCount;
        }

        public String getKey() {
            return this.key;
        }

        public Double getFrom() {
            return this.from;
        }

        public Double getTo() {
            return this.to;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public String toString() {
            return String.format("RangeBucket{key='%s', from=%s, to=%s, docCount=%d}", this.key, this.from, this.to, this.docCount);
        }
    }
}

