/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.split.SplitAggregation;
import java.util.ArrayList;
import java.util.List;

public class RangeAggregation
extends SplitAggregation {
    private final String fieldName;
    private final List<RangeSpec> ranges;

    public RangeAggregation(String fieldName) {
        super("range_" + fieldName);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
        this.ranges = new ArrayList<RangeSpec>();
    }

    public RangeAggregation(String name, String fieldName) {
        super(name);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
        this.ranges = new ArrayList<RangeSpec>();
    }

    public RangeAggregation addRange(String key, Double from, Double to) {
        this.ranges.add(new RangeSpec(key, from, to));
        return this;
    }

    public RangeAggregation addRange(Double from, Double to) {
        return this.addRange(null, from, to);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getAggregationType() {
        return "range";
    }

    @Override
    public String toAggregationJson() {
        if (this.ranges.isEmpty()) {
            throw new IllegalStateException("Range aggregation must have at least one range");
        }
        StringBuilder json = new StringBuilder();
        json.append("{\"range\": {\"field\": \"").append(this.fieldName).append("\", \"ranges\": [");
        for (int i = 0; i < this.ranges.size(); ++i) {
            if (i > 0) {
                json.append(", ");
            }
            json.append(this.ranges.get(i).toJson());
        }
        json.append("]}}");
        return json.toString();
    }

    public List<RangeSpec> getRanges() {
        return new ArrayList<RangeSpec>(this.ranges);
    }

    public String toString() {
        return String.format("RangeAggregation{name='%s', field='%s', ranges=%d}", this.name, this.fieldName, this.ranges.size());
    }

    public static class RangeSpec {
        private final String key;
        private final Double from;
        private final Double to;

        public RangeSpec(String key, Double from, Double to) {
            this.key = key;
            this.from = from;
            this.to = to;
        }

        public String getKey() {
            return this.key;
        }

        public Double getFrom() {
            return this.from;
        }

        public Double getTo() {
            return this.to;
        }

        public String toJson() {
            StringBuilder json = new StringBuilder("{");
            if (this.key != null) {
                json.append("\"key\": \"").append(this.key).append("\"");
            }
            if (this.from != null) {
                if (this.key != null) {
                    json.append(", ");
                }
                json.append("\"from\": ").append(this.from);
            }
            if (this.to != null) {
                if (this.key != null || this.from != null) {
                    json.append(", ");
                }
                json.append("\"to\": ").append(this.to);
            }
            json.append("}");
            return json.toString();
        }

        public String toString() {
            return String.format("RangeSpec{key='%s', from=%s, to=%s}", this.key, this.from, this.to);
        }
    }
}

