/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.aggregation.AggregationResult;
import io.indextables.tantivy4java.aggregation.TermsResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MultiTermsResult
implements AggregationResult {
    private final List<MultiTermsBucket> buckets;
    private final String[] fieldNames;
    private final String name;

    public MultiTermsResult(String name, TermsResult rootTermsResult, String[] fieldNames) {
        if (fieldNames == null || fieldNames.length < 2) {
            throw new IllegalArgumentException("MultiTermsResult requires at least 2 field names");
        }
        this.name = name != null ? name : "multi_terms";
        this.fieldNames = Arrays.copyOf(fieldNames, fieldNames.length);
        this.buckets = new ArrayList<MultiTermsBucket>();
        if (rootTermsResult != null) {
            this.flattenNestedBuckets(rootTermsResult, new ArrayList<String>(), 0);
        }
    }

    private void flattenNestedBuckets(TermsResult termsResult, List<String> currentPath, int depth) {
        if (termsResult == null) {
            return;
        }
        for (TermsResult.TermsBucket bucket : termsResult.getBuckets()) {
            ArrayList<String> bucketPath = new ArrayList<String>(currentPath);
            bucketPath.add(bucket.getKeyAsString());
            if (depth == this.fieldNames.length - 1) {
                String[] fieldValues = bucketPath.toArray(new String[0]);
                Map<String, AggregationResult> subAggs = bucket.getSubAggregations();
                MultiTermsBucket multiTermsBucket = new MultiTermsBucket(fieldValues, bucket.getDocCount(), subAggs);
                this.buckets.add(multiTermsBucket);
                continue;
            }
            String nextFieldAggName = this.fieldNames[depth + 1] + "_terms";
            AggregationResult nextLevel = bucket.getSubAggregation(nextFieldAggName);
            if (!(nextLevel instanceof TermsResult)) continue;
            this.flattenNestedBuckets((TermsResult)nextLevel, bucketPath, depth + 1);
        }
    }

    public List<MultiTermsBucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    public String[] getFieldNames() {
        return Arrays.copyOf(this.fieldNames, this.fieldNames.length);
    }

    public int getBucketCount() {
        return this.buckets.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return "multi_terms";
    }

    public String toString() {
        return "MultiTermsResult{name='" + this.name + "', fields=" + Arrays.toString(this.fieldNames) + ", buckets=" + this.buckets.size() + "}";
    }

    public static class MultiTermsBucket {
        private final String[] fieldValues;
        private final long docCount;
        private final Map<String, AggregationResult> subAggregations;

        public MultiTermsBucket(String[] fieldValues, long docCount, Map<String, AggregationResult> subAggregations) {
            this.fieldValues = Arrays.copyOf(fieldValues, fieldValues.length);
            this.docCount = docCount;
            this.subAggregations = subAggregations != null ? new HashMap<String, AggregationResult>(subAggregations) : new HashMap();
        }

        public String[] getFieldValues() {
            return Arrays.copyOf(this.fieldValues, this.fieldValues.length);
        }

        public String getFieldValue(int index) {
            if (index < 0 || index >= this.fieldValues.length) {
                throw new IndexOutOfBoundsException("Field index " + index + " out of bounds for " + this.fieldValues.length + " fields");
            }
            return this.fieldValues[index];
        }

        public Map<String, String> getFieldValuesMap(String[] fieldNames) {
            if (fieldNames.length != this.fieldValues.length) {
                throw new IllegalArgumentException("Field names length must match field values length");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < fieldNames.length; ++i) {
                map.put(fieldNames[i], this.fieldValues[i]);
            }
            return map;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public AggregationResult getSubAggregation(String name) {
            return this.subAggregations.get(name);
        }

        public Map<String, AggregationResult> getSubAggregations() {
            return Collections.unmodifiableMap(this.subAggregations);
        }

        public boolean hasSubAggregations() {
            return !this.subAggregations.isEmpty();
        }

        public String getCompositeKey() {
            return this.getCompositeKey("|");
        }

        public String getCompositeKey(String delimiter) {
            return String.join((CharSequence)delimiter, this.fieldValues);
        }

        public String toString() {
            return "MultiTermsBucket{fieldValues=" + Arrays.toString(this.fieldValues) + ", docCount=" + this.docCount + ", subAggregations=" + String.valueOf(this.subAggregations.keySet()) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiTermsBucket that = (MultiTermsBucket)o;
            return this.docCount == that.docCount && Arrays.equals(this.fieldValues, that.fieldValues) && Objects.equals(this.subAggregations, that.subAggregations);
        }

        public int hashCode() {
            int result = Objects.hash(this.docCount, this.subAggregations);
            result = 31 * result + Arrays.hashCode(this.fieldValues);
            return result;
        }
    }
}

