/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.split.SplitAggregation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class MultiTermsAggregation
extends SplitAggregation {
    private final String[] fields;
    private final int size;
    private final int shardSize;
    private final Map<String, SplitAggregation> subAggregations;

    public MultiTermsAggregation(String[] fields) {
        this("multi_terms_" + (fields != null ? String.join((CharSequence)"_", fields) : "null"), fields, 10, 0);
    }

    public MultiTermsAggregation(String[] fields, int size) {
        this("multi_terms_" + (fields != null ? String.join((CharSequence)"_", fields) : "null"), fields, size, 0);
    }

    public MultiTermsAggregation(String name, String[] fields, int size, int shardSize) {
        super(name);
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("Fields array cannot be null or empty");
        }
        if (fields.length == 1) {
            throw new IllegalArgumentException("Use TermsAggregation for single field grouping");
        }
        for (String field : fields) {
            if (field != null && !field.trim().isEmpty()) continue;
            throw new IllegalArgumentException("Field names cannot be null or empty");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive");
        }
        this.fields = Arrays.copyOf(fields, fields.length);
        this.size = size;
        this.shardSize = shardSize;
        this.subAggregations = new HashMap<String, SplitAggregation>();
    }

    public void addSubAggregation(String name, SplitAggregation aggregation) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Sub-aggregation name cannot be null or empty");
        }
        if (aggregation == null) {
            throw new IllegalArgumentException("Sub-aggregation cannot be null");
        }
        this.subAggregations.put(name.trim(), aggregation);
    }

    public String[] getFields() {
        return Arrays.copyOf(this.fields, this.fields.length);
    }

    @Override
    public String getFieldName() {
        return this.fields[0];
    }

    @Override
    public String getAggregationType() {
        return "multi_terms";
    }

    @Override
    public String toAggregationJson() {
        return this.generateNestedAggregationJson(0, this.subAggregations);
    }

    private String generateNestedAggregationJson(int fieldIndex, Map<String, SplitAggregation> leafSubAggs) {
        if (fieldIndex >= this.fields.length) {
            if (leafSubAggs.isEmpty()) {
                return "{}";
            }
            StringBuilder json = new StringBuilder();
            json.append("{");
            boolean first = true;
            for (Map.Entry<String, SplitAggregation> entry : leafSubAggs.entrySet()) {
                if (!first) {
                    json.append(", ");
                }
                json.append("\"").append(entry.getKey()).append("\": ");
                json.append(entry.getValue().toAggregationJson());
                first = false;
            }
            json.append("}");
            return json.toString();
        }
        String currentField = this.fields[fieldIndex];
        StringBuilder json = new StringBuilder();
        json.append("{\"terms\": {\"field\": \"").append(currentField).append("\"");
        json.append(", \"size\": ").append(this.size);
        if (this.shardSize > 0) {
            json.append(", \"shard_size\": ").append(this.shardSize);
        }
        json.append("}");
        if (fieldIndex < this.fields.length - 1 || !leafSubAggs.isEmpty()) {
            json.append(", \"aggs\": {");
            if (fieldIndex < this.fields.length - 1) {
                String nextFieldAggName = this.fields[fieldIndex + 1] + "_terms";
                json.append("\"").append(nextFieldAggName).append("\": ");
                json.append(this.generateNestedAggregationJson(fieldIndex + 1, leafSubAggs));
            } else {
                boolean first = true;
                for (Map.Entry<String, SplitAggregation> entry : leafSubAggs.entrySet()) {
                    if (!first) {
                        json.append(", ");
                    }
                    json.append("\"").append(entry.getKey()).append("\": ");
                    json.append(entry.getValue().toAggregationJson());
                    first = false;
                }
            }
            json.append("}");
        }
        json.append("}");
        return json.toString();
    }

    public String toString() {
        return "MultiTermsAggregation{name='" + this.getName() + "', fields=" + Arrays.toString(this.fields) + ", size=" + this.size + ", shardSize=" + this.shardSize + ", subAggregations=" + String.valueOf(this.subAggregations.keySet()) + "}";
    }
}

