/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.split.SplitAggregation;

public class MinAggregation
extends SplitAggregation {
    private final String fieldName;

    public MinAggregation(String fieldName) {
        super("min_" + fieldName);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
    }

    public MinAggregation(String name, String fieldName) {
        super(name);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getAggregationType() {
        return "min";
    }

    @Override
    public String toAggregationJson() {
        return String.format("{\"min\": {\"field\": \"%s\"}}", this.fieldName);
    }

    public String toString() {
        return String.format("MinAggregation{name='%s', field='%s'}", this.name, this.fieldName);
    }
}

