/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.split.SplitAggregation;

public class MaxAggregation
extends SplitAggregation {
    private final String fieldName;

    public MaxAggregation(String fieldName) {
        super("max_" + fieldName);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
    }

    public MaxAggregation(String name, String fieldName) {
        super(name);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getAggregationType() {
        return "max";
    }

    @Override
    public String toAggregationJson() {
        return String.format("{\"max\": {\"field\": \"%s\"}}", this.fieldName);
    }

    public String toString() {
        return String.format("MaxAggregation{name='%s', field='%s'}", this.name, this.fieldName);
    }
}

