/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.aggregation.AggregationResult;
import java.util.List;

public class HistogramResult
implements AggregationResult {
    private final String name;
    private final List<HistogramBucket> buckets;

    public HistogramResult(String name, List<HistogramBucket> buckets) {
        this.name = name;
        this.buckets = buckets;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return "histogram";
    }

    public List<HistogramBucket> getBuckets() {
        return this.buckets;
    }

    public String toString() {
        return String.format("HistogramResult{name='%s', buckets=%d}", this.name, this.buckets.size());
    }

    public static class HistogramBucket {
        private final double key;
        private final long docCount;

        public HistogramBucket(double key, long docCount) {
            this.key = key;
            this.docCount = docCount;
        }

        public double getKey() {
            return this.key;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public String toString() {
            return String.format("HistogramBucket{key=%.2f, docCount=%d}", this.key, this.docCount);
        }
    }
}

