/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.split.SplitAggregation;

public class HistogramAggregation
extends SplitAggregation {
    private final String fieldName;
    private double interval;
    private Double offset;
    private Double minDocCount;

    public HistogramAggregation(String fieldName, double interval) {
        super("histogram_" + fieldName);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        if (interval <= 0.0) {
            throw new IllegalArgumentException("Interval must be positive");
        }
        this.fieldName = fieldName.trim();
        this.interval = interval;
    }

    public HistogramAggregation(String name, String fieldName, double interval) {
        super(name);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        if (interval <= 0.0) {
            throw new IllegalArgumentException("Interval must be positive");
        }
        this.fieldName = fieldName.trim();
        this.interval = interval;
    }

    public HistogramAggregation setInterval(double interval) {
        if (interval <= 0.0) {
            throw new IllegalArgumentException("Interval must be positive");
        }
        this.interval = interval;
        return this;
    }

    public HistogramAggregation setOffset(double offset) {
        this.offset = offset;
        return this;
    }

    public HistogramAggregation setMinDocCount(double minDocCount) {
        this.minDocCount = minDocCount;
        return this;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getAggregationType() {
        return "histogram";
    }

    @Override
    public String toAggregationJson() {
        StringBuilder json = new StringBuilder();
        json.append("{\"histogram\": {\"field\": \"").append(this.fieldName).append("\"");
        json.append(", \"interval\": ").append(this.interval);
        if (this.offset != null) {
            json.append(", \"offset\": ").append(this.offset);
        }
        if (this.minDocCount != null) {
            json.append(", \"min_doc_count\": ").append(this.minDocCount);
        }
        json.append("}}");
        return json.toString();
    }

    public double getInterval() {
        return this.interval;
    }

    public Double getOffset() {
        return this.offset;
    }

    public Double getMinDocCount() {
        return this.minDocCount;
    }

    public String toString() {
        return String.format("HistogramAggregation{name='%s', field='%s', interval=%.2f}", this.name, this.fieldName, this.interval);
    }
}

