/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.aggregation.AggregationResult;
import java.util.List;

public class DateHistogramResult
implements AggregationResult {
    private final String name;
    private final List<DateHistogramBucket> buckets;

    public DateHistogramResult(String name, List<DateHistogramBucket> buckets) {
        this.name = name;
        this.buckets = buckets;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return "date_histogram";
    }

    public List<DateHistogramBucket> getBuckets() {
        return this.buckets;
    }

    public String toString() {
        return String.format("DateHistogramResult{name='%s', buckets=%d}", this.name, this.buckets.size());
    }

    public static class DateHistogramBucket {
        private final double key;
        private final String keyAsString;
        private final long docCount;

        public DateHistogramBucket(double key, String keyAsString, long docCount) {
            this.key = key;
            this.keyAsString = keyAsString;
            this.docCount = docCount;
        }

        public double getKey() {
            return this.key;
        }

        public String getKeyAsString() {
            return this.keyAsString;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public String toString() {
            return String.format("DateHistogramBucket{key=%.0f, keyAsString='%s', docCount=%d}", this.key, this.keyAsString, this.docCount);
        }
    }
}

