/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.split.SplitAggregation;

public class DateHistogramAggregation
extends SplitAggregation {
    private final String fieldName;
    private String fixedInterval;
    private String calendarInterval;
    private String offset;
    private String timeZone;
    private String format;
    private ExtendedBounds extendedBounds;

    public DateHistogramAggregation(String fieldName) {
        super("date_histogram_" + fieldName);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
    }

    public DateHistogramAggregation(String name, String fieldName) {
        super(name);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
    }

    public DateHistogramAggregation setFixedInterval(String interval) {
        this.fixedInterval = interval;
        this.calendarInterval = null;
        return this;
    }

    public DateHistogramAggregation setCalendarInterval(String interval) {
        this.calendarInterval = interval;
        this.fixedInterval = null;
        return this;
    }

    public DateHistogramAggregation setOffset(String offset) {
        this.offset = offset;
        return this;
    }

    public DateHistogramAggregation setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public DateHistogramAggregation setFormat(String format) {
        this.format = format;
        return this;
    }

    public DateHistogramAggregation setExtendedBounds(long min, long max) {
        this.extendedBounds = new ExtendedBounds(min, max);
        return this;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getAggregationType() {
        return "date_histogram";
    }

    @Override
    public String toAggregationJson() {
        if (this.fixedInterval == null && this.calendarInterval == null) {
            throw new IllegalStateException("Date histogram must have either fixed_interval or calendar_interval");
        }
        StringBuilder json = new StringBuilder();
        json.append("{\"date_histogram\": {\"field\": \"").append(this.fieldName).append("\"");
        if (this.fixedInterval != null) {
            json.append(", \"fixed_interval\": \"").append(this.fixedInterval).append("\"");
        }
        if (this.calendarInterval != null) {
            json.append(", \"calendar_interval\": \"").append(this.calendarInterval).append("\"");
        }
        if (this.offset != null) {
            json.append(", \"offset\": \"").append(this.offset).append("\"");
        }
        if (this.timeZone != null) {
            json.append(", \"time_zone\": \"").append(this.timeZone).append("\"");
        }
        if (this.format != null) {
            json.append(", \"format\": \"").append(this.format).append("\"");
        }
        if (this.extendedBounds != null) {
            json.append(", \"extended_bounds\": {");
            json.append("\"min\": ").append(this.extendedBounds.min);
            json.append(", \"max\": ").append(this.extendedBounds.max);
            json.append("}");
        }
        json.append("}}");
        return json.toString();
    }

    public String getFixedInterval() {
        return this.fixedInterval;
    }

    public String getCalendarInterval() {
        return this.calendarInterval;
    }

    public String getOffset() {
        return this.offset;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getFormat() {
        return this.format;
    }

    public ExtendedBounds getExtendedBounds() {
        return this.extendedBounds;
    }

    public String toString() {
        String interval = this.fixedInterval != null ? this.fixedInterval : this.calendarInterval;
        return String.format("DateHistogramAggregation{name='%s', field='%s', interval='%s'}", this.name, this.fieldName, interval);
    }

    public static class ExtendedBounds {
        public final long min;
        public final long max;

        public ExtendedBounds(long min, long max) {
            this.min = min;
            this.max = max;
        }

        public String toString() {
            return String.format("ExtendedBounds{min=%d, max=%d}", this.min, this.max);
        }
    }
}

