/*
 * Decompiled with CFR 0.152.
 */
package io.indextables.tantivy4java.aggregation;

import io.indextables.tantivy4java.split.SplitAggregation;

public class CountAggregation
extends SplitAggregation {
    private final String fieldName;

    public CountAggregation(String fieldName) {
        super("count_" + fieldName);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
    }

    public CountAggregation(String name, String fieldName) {
        super(name);
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        this.fieldName = fieldName.trim();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getAggregationType() {
        return "value_count";
    }

    @Override
    public String toAggregationJson() {
        return String.format("{\"value_count\": {\"field\": \"%s\"}}", this.fieldName);
    }

    public String toString() {
        return String.format("CountAggregation{name='%s', field='%s'}", this.name, this.fieldName);
    }
}

